package mods.immibis.lxp;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.*;

import org.lwjgl.opengl.GL11;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;

import mods.immibis.core.api.porting.SidedProxy;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.Vec3;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ObviousClassUsedForNonMaliciousTrollingOfGreg {
	
	private static final boolean TESTING = false;
	private static final boolean PRINT_LOGS = false && !TESTING; // spams console
	
	// option: -DESIST.THIS=PREPOSTEROUSNESS
	private static final boolean DESIST_THIS_PREPOSTEROUSNESS = System.getProperty("ESIST.THIS", "").equals("PREPOSTEROUSNESS");
	
	// option: -DAMN.YOU.STOP.IT=ALREADY
	private static final boolean DAMN_YOU_STOP_IT_ALREADY = System.getProperty("AMN.YOU.STOP.IT", "").equals("ALREADY");
	
	// option: -DAAAAAAAARRRRRRG=H
	private static final boolean DAAAAAAAARRRRRRGH = System.getProperty("AAAAAAAARRRRRRG", "").equals("H");
			
	
	public static boolean ENABLED;
	
	public static boolean isValidUsername(String username) {
		return username.equalsIgnoreCase("GregoriusT") || (TESTING && username.equalsIgnoreCase("immibis"));
	};
	
	public static void preinit() {
		String username = Minecraft.getMinecraft().session.username;
		
		if(!isValidUsername(username))
			return;
		
		if(SidedProxy.instance.isDedicatedServer())
			// wouldn't want this to affect gameplay in SMP
			return;
		
		System.err.println("Hello GregoriusT.");
		if(!DESIST_THIS_PREPOSTEROUSNESS)
			System.err.println("-DESIST.THIS=PREPOSTEROUSNESS");
		else if(!DAMN_YOU_STOP_IT_ALREADY)
			System.err.println("-DAMN.YOU.STOP.IT=ALREADY");
		else if(!DAAAAAAAARRRRRRGH)
			System.err.println("-DAAAAAAAARRRRRRG=H");
		else
			System.err.println("All trolling disabled :(");
		
		
		ENABLED = true;
		
		try {
			if(!DAMN_YOU_STOP_IT_ALREADY)
				trollOreDict();
		} catch(Throwable t) {
		}
	}
	
	public static void postinit() {
		if(!ENABLED) return;
		
	
		try {
			if(!DAMN_YOU_STOP_IT_ALREADY) {
				trollRecipes();
				trollNewRecipes();
				LanguageRegistry.addName(Item.netherStar, "How to Troll a GregoriusT");
			}
			
			if(!DESIST_THIS_PREPOSTEROUSNESS)
				trollSpawning();
			
			if(!DAAAAAAAARRRRRRGH)
				trollModels();
		} catch(Throwable t) {
			t.printStackTrace();
		}
	}
	
	private static void trollSpawning() {
		TickRegistry.registerTickHandler(new ITickHandler() {
			
			private List<WeakReference<EntityLiving>> trolls = new LinkedList<WeakReference<EntityLiving>>();
			
			@Override
			public EnumSet<TickType> ticks() {
				return EnumSet.of(TickType.CLIENT);
			}
			
			@Override
			public void tickStart(EnumSet<TickType> type, Object... tickData) {
			}
			
			Random r = new Random();
			
			final double RADIUS = 8;
			
			boolean exploding = false;
			final int EXPLOSIONS_PER_TICK = 4;
			
			// was 3, but then the explosion pushes the player, which affects gameplay (could knock them into lava)
			final float EXPLOSION_STRENGTH = 0;
			
			int mobType = r.nextInt(3);
			
			final int MAX_COOLDOWN = 12000; // 10 minutes
			final int MIN_COOLDOWN = 4800; // 4 minutes
			int cooldownTicks = MIN_COOLDOWN + r.nextInt(MAX_COOLDOWN - MIN_COOLDOWN + 1);
			
			@Override
			public void tickEnd(EnumSet<TickType> type, Object... tickData) {
				while(trolls.size() > 0) {
					WeakReference<EntityLiving> first = trolls.get(0);
					EntityLiving c = first.get();
					if(c != null && !c.isDead)
						break;
					trolls.remove(0);
				}
				
				
				
				if(Minecraft.getMinecraft().theWorld == null)
					return;
				
				if(Minecraft.getMinecraft().isGamePaused)
					return;
				
				EntityClientPlayerMP pl = Minecraft.getMinecraft().thePlayer;
				
				if(pl == null)
					return;
				
				
				
				EntityLiving c;
				
				if(exploding) {
					for(int k = 0; k < EXPLOSIONS_PER_TICK; k++) {
						if(trolls.size() == 0) {
							exploding = false;
							mobType = (mobType + 1) % 3;
							cooldownTicks = MAX_COOLDOWN + r.nextInt(MAX_COOLDOWN - MIN_COOLDOWN + 1);
							break;
						}
						
						WeakReference<EntityLiving> ref = trolls.remove(0);
						c = ref.get();
						if(c == null || c.isDead) {
							continue;
						}
						
						c.worldObj.createExplosion(c, c.posX, c.posY, c.posZ, EXPLOSION_STRENGTH, false);
						c.setDead();
					}
				}
				
				//System.out.println(cooldownTicks);
				if(cooldownTicks > 0) {
					cooldownTicks--;
					return;
				}
				
				if(mobType == 0)
					c = new EntityCreeper(pl.worldObj);
				else if(mobType == 1)
					c = new EntitySkeleton(pl.worldObj);
				else
					c = new EntityZombie(pl.worldObj);
				c.setPosition(pl.posX + r.nextDouble() * (RADIUS * 2) - RADIUS,
					pl.posY + r.nextDouble() * (RADIUS * 2) - RADIUS,
					pl.posZ + r.nextDouble() * (RADIUS * 2) - RADIUS);
				c.rotationYawHead = (float)(r.nextDouble() * Math.PI * 2);
				c.rotationYaw = (float)(r.nextDouble() * Math.PI * 2);
				c.rotationPitch = (float)(r.nextDouble() * Math.PI * 2);
				
				pl.worldObj.spawnEntityInWorld(c);
				
				trolls.add(new WeakReference<EntityLiving>(c));
				
				if(trolls.size() > 50) {
					exploding = true;
				}
			}
			
			@Override
			public String getLabel() {
				return "creepermatic";
			}
		}, Side.CLIENT);
	}
	
	private static void trollModels() {
		TickRegistry.registerTickHandler(new ITickHandler() {
			
			private List<ModelBase> models = new ArrayList<ModelBase>();
			private List<ModelRenderer> boxGroups = new ArrayList<ModelRenderer>();
			private List<ModelBox> boxes = new ArrayList<ModelBox>();
			
			private Map<PositionTextureVertex, Vec3> origValues = new HashMap<PositionTextureVertex, Vec3>();
			
			{
				for(Map.Entry<Class<?>, Render> e : ((Map<Class<?>, Render>)RenderManager.instance.entityRenderMap).entrySet()) {
					try {
						Class<?> c = e.getKey();
						Render r = e.getValue();
						//if(!EntityAnimal.class.isAssignableFrom(c))
						//	continue;
						
						if(r instanceof RenderLiving) {
							ModelBase m = ReflectionHelper.getPrivateValue(RenderLiving.class, (RenderLiving)r, 0);
							models.add(m);
							for(Field f : m.getClass().getFields()) {
								if(f.getType() == ModelRenderer.class && f.get(m) != null) {
									boxGroups.add((ModelRenderer)f.get(m));
									boxes.addAll((List<ModelBox>)((ModelRenderer)f.get(m)).cubeList);
								}
							}
						}
					} catch(Throwable t) {
						t.printStackTrace();
					}
				}
				
				for(ModelBox b : boxes) {
					for(TexturedQuad tq : (TexturedQuad[])ReflectionHelper.getPrivateValue(ModelBox.class, b, 1)) {
						for(PositionTextureVertex v : tq.vertexPositions) {
							origValues.put(v, v.vector3D.addVector(0, 0, 0));
						}
					}
				}
			}
			
			void rescale(double scale) {
				for(ModelBox b : boxes) {
					float cx = (b.posX1 + b.posX2) / 2;
					float cy = (b.posY1 + b.posY2) / 2;
					float cz = (b.posZ1 + b.posZ2) / 2;
					for(TexturedQuad tq : (TexturedQuad[])ReflectionHelper.getPrivateValue(ModelBox.class, b, 1)) {
						for(PositionTextureVertex v : tq.vertexPositions) {
							Vec3 orig = origValues.get(v);
							v.vector3D.xCoord = (orig.xCoord - cx) * scale + cx;
							v.vector3D.yCoord = (orig.yCoord - cy) * scale + cy;
							v.vector3D.zCoord = (orig.zCoord - cz) * scale + cz;
						}
					}
				}
			}
			
			void uncacheModels() {
				for(ModelRenderer bg : boxGroups) {
					if(!(Boolean)ReflectionHelper.getPrivateValue(ModelRenderer.class, bg, 10))
						continue; // not compiled into a display list
					
					// recompile display list
					int dl = ReflectionHelper.getPrivateValue(ModelRenderer.class, bg, 11);
					
					GL11.glNewList(dl, GL11.GL_COMPILE);
			        Tessellator tessellator = Tessellator.instance;

			        for(ModelBox box : (List<ModelBox>)bg.cubeList)
			        	box.render(tessellator, 0.0625f);

			        GL11.glEndList();
				}
			}
			
			@Override
			public EnumSet<TickType> ticks() {
				return EnumSet.of(TickType.CLIENT);
			}
			
			@Override
			public void tickStart(EnumSet<TickType> type, Object... tickData) {
			}
			
			final int MIN_COOLDOWN = 100; // 5 seconds
			final int MAX_COOLDOWN = 300; // 15 seconds
			
			final int DURATION = 300; // 15 seconds
			final double MAX_SCALE = 2.0;
			final double MIN_SCALE = 0.0;
			
			Random r = new Random();
			int ticks = 0;
			int cooldownTicks = MIN_COOLDOWN + r.nextInt(MAX_COOLDOWN - MIN_COOLDOWN + 1);
			
			@Override
			public void tickEnd(EnumSet<TickType> type, Object... tickData) {
				if(cooldownTicks > 0) {
					cooldownTicks--;
					return;
				}
				
				ticks++;
				if(ticks >= DURATION) {
					cooldownTicks = MIN_COOLDOWN + r.nextInt(MAX_COOLDOWN - MIN_COOLDOWN + 1);
					ticks = 0;
					rescale(1.0);
				} else {
					double scale = MIN_SCALE + (MAX_SCALE - MIN_SCALE) * (0.5 + 0.5 * Math.sin(ticks / (double)DURATION * Math.PI * 2));
					rescale(scale);
				}
				
				uncacheModels();
			}
			
			@Override
			public String getLabel() {
				return "zoomomatic";
			}
		}, Side.CLIENT);
	}
	
	
	private static boolean oreRecipeInputsEqual(Object a, Object b) {
		if(a instanceof ItemStack && b instanceof ItemStack && ItemStack.areItemStacksEqual((ItemStack)a, (ItemStack)b))
			return true;
		return a == b;
	}
	
	private static void trollOreDict() {
		Random r = new Random();
		
		// For each ore dictionary name...
		for(String oreName : OreDictionary.getOreNames()) {
			// ... with a 20% chance ...
			if(r.nextDouble() < 0.2) {
				// ... add a random item to it.
				
				boolean requiresBlock =
					oreName.startsWith("ore")
					|| oreName.startsWith("block");
				
				ItemStack stack = getRandomItemStack(r, requiresBlock);
				if(stack != null)
					OreDictionary.registerOre(oreName, stack);
				
				System.err.println("Trollificating ore dictionary: "+oreName);
			}
		}
	}
	
	private static void trollNewRecipes() {
		String[][] patterns = {
			{"ABA", "BAB", "ABA"},
			{"AAA", "ABA", "AAA"},
			{" A ", "BCB", " A "},
			{"AAA", "A A", "AAA"},
			{"AAA", " B ", "CCC"},
			{"AAA", "BBB", "AAA"},
			{"ABA", "ABA", "ABA"},
			{"AAA", "BCB", "AAA"},
			{"ABA", "BCB", "ABA"},
			{"A A", "   ", "A A"},
			{"AA", "AA"},
			{"ABA", "ACA", " D "},
		};
		
		char[] subs = {'A', 'B', 'C', 'D'};
		
		Random r = new Random();
		
		int num = CraftingManager.getInstance().getRecipeList().size() / 20;
		for(int k = 0; k < num; k++) {
			String[] pattern = patterns[r.nextInt(patterns.length)];
			
			List<Object> args = new ArrayList<Object>();
			for(String s : pattern)
				args.add(s);
			for(char c : subs) {
				args.add(c);
				args.add(getRandomItemStack(r, false));
			}
			
			ItemStack output = getRandomItemStack(r, false);
			System.err.println("Fabricratrolling recipe for "+output);
			GameRegistry.addRecipe(output, args.toArray());
		}
	}
	
	private static void trollRecipes() {
		Random r = new Random();
		
		// Also, for each recipe
		for(IRecipe recipe : (List<IRecipe>)CraftingManager.getInstance().getRecipeList()) {
			// with a 20% chance
			if(r.nextDouble() > 0.2)
				continue;
			
			try {
				if(recipe instanceof ShapelessRecipes) {
					// if it's shapeless, fill it with random items
					ShapelessRecipes sr = (ShapelessRecipes)recipe;
					int max = sr.recipeItems.size() <= 4 ? 4 : 9;
					
					while(sr.recipeItems.size() < max)
						sr.recipeItems.add(getRandomItemStack(r, false));
					
					if(PRINT_LOGS)
						System.err.println("Trollificating recipe for "+recipe.getRecipeOutput());
				}
				
				if(recipe instanceof ShapedRecipes) {
					// if it's shaped, replace a random item type (can't change size, array is final)
					ShapedRecipes sr = (ShapedRecipes)recipe;
					
					// get unique stacks in recipe
					ItemStack[] types = new ItemStack[9];
					int nTypes = 0;
					for(ItemStack is : sr.recipeItems) {
						boolean alreadyAdded = false;
						for(int k = 0; k < nTypes; k++)
							if(ItemStack.areItemStacksEqual(types[k], is))
								alreadyAdded = true;
						
						if(!alreadyAdded && is != null)
							types[nTypes++] = is;
					}
					
					if(nTypes == 0)
						continue;
					
					ItemStack replacing = types[r.nextInt(nTypes)];
					ItemStack replaceWith = getRandomItemStack(r, false);
					
					for(int k = 0; k < sr.recipeItems.length; k++)
						if(ItemStack.areItemStacksEqual(sr.recipeItems[k], replacing))
							sr.recipeItems[k] = replaceWith;
					
					//sr.recipeItems[r.nextInt(sr.recipeItems.length)] = getRandomItemStack(r, false);
					
					if(PRINT_LOGS)
						System.err.println("Trollificating recipe for "+recipe.getRecipeOutput());
				}
				
				if(recipe instanceof ShapedOreRecipe) {
					// if it's a shaped ore recipe, do the same thing (although array is not final)
					
					ShapedOreRecipe sr = (ShapedOreRecipe)recipe;
					Object[] input = ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, sr, "input");
					
					// get unique inputs in recipe
					Object[] types = new Object[9];
					int nTypes = 0;
					for(Object o : input) {
						boolean alreadyAdded = false;
						
						for(int k = 0; k < nTypes; k++)
							if(oreRecipeInputsEqual(types[k], o))
								alreadyAdded = true;
						
						if(!alreadyAdded)
							types[nTypes++] = o;
					}
					
					if(nTypes == 0)
						continue;
					
					Object replacing = types[r.nextInt(nTypes)];
					Object replaceWith = r.nextDouble() < 0.3 ? getRandomOreList(r) : getRandomItemStack(r, false);
					
					for(int k = 0; k < input.length; k++)
						if(oreRecipeInputsEqual(input[k], replacing))
							input[k] = replaceWith;
					
					// input[r.nextInt(input.length)] = getRandomItemStack(r, false);
					
					if(PRINT_LOGS)
						System.err.println("Trollificating recipe for "+recipe.getRecipeOutput());
				}
				// shapeless ore recipes and IC2 recipes are left alone
				
			} catch(Throwable t) {
			}
		}
	}
	
	private static class HashableStackWrapper {
		private final ItemStack stack;
		private final int hashCode;
		
		public HashableStackWrapper(ItemStack stack) {
			this.stack = stack.copy();
			this.hashCode = stack.itemID ^ (stack.getItemDamage() * 123457) ^ (stack.stackTagCompound != null ? stack.stackTagCompound.hashCode() : 0);
		}
		
		@Override
		public int hashCode() {
			return hashCode;
		}
		
		@Override
		public boolean equals(Object obj) {
			if(obj instanceof ItemStack)
				return ItemStack.areItemStacksEqual((ItemStack)obj, stack);
			if(obj instanceof HashableStackWrapper)
				return ItemStack.areItemStacksEqual(((HashableStackWrapper)obj).stack, stack);
			return false;
		}
	}
	
	private static ArrayList<ItemStack> possibleStacks;
	private static ArrayList<ItemStack> possibleBlocks;
	
	private static void initPossibleStacks() {
		possibleStacks = new ArrayList<ItemStack>();
		possibleBlocks = new ArrayList<ItemStack>();
		
		HashSet<HashableStackWrapper> rv = new HashSet<HashableStackWrapper>();
		for(Item i : Item.itemsList) {
			if(i == null)
				continue;
			
			try {
				if(i.getCreativeTab() == null) {
					rv.add(new HashableStackWrapper(new ItemStack(i, 1, 0)));
					
				} else {
					List<ItemStack> temp = new ArrayList<ItemStack>();
					i.getSubItems(i.itemID, i.getCreativeTab(), temp);
					for(ItemStack is : temp)
						rv.add(new HashableStackWrapper(is));
				}
			} catch(Throwable t) {
			}
		}
		
		for(String oreName : OreDictionary.getOreNames())
			for(ItemStack ore : OreDictionary.getOres(oreName))
				try {
					rv.add(new HashableStackWrapper(ore));
				} catch(Throwable t) {
				}
		
		for(HashableStackWrapper w : rv) {
			possibleStacks.add(w.stack);
			if(w.stack.itemID >= 0 && w.stack.itemID <= Block.blocksList.length && Block.blocksList[w.stack.itemID] != null)
				possibleBlocks.add(w.stack);
		}
	}
	
	public static ItemStack getRandomItemStack(Random r, boolean requiresBlock) {
		if(possibleStacks == null)
			initPossibleStacks();
		
		if(!requiresBlock && r.nextDouble() < 0.05)
			return new ItemStack(Item.netherStar);
		
		ArrayList<ItemStack> list = requiresBlock ? possibleBlocks : possibleStacks;
		if(list.size() == 0)
			return null;
		return list.get(r.nextInt(list.size()));
	}
	
	private static List<ItemStack>[] oreLists;
	public static List<ItemStack> getRandomOreList(Random r) {
		if(oreLists == null) {
			String[] names = OreDictionary.getOreNames();
			oreLists = new List[names.length];
			for(int k = 0; k < names.length; k++)
				oreLists[k] = OreDictionary.getOres(names[k]);
		}
		return oreLists[r.nextInt(oreLists.length)];
	}
}
