package mods.immibis.lxp;

import mods.immibis.cobaltite.AssignedBlock;
import mods.immibis.cobaltite.AssignedItem;
import mods.immibis.cobaltite.CobaltiteMod;
import mods.immibis.cobaltite.Configurable;
import mods.immibis.cobaltite.ModBase;
import mods.immibis.cobaltite.TileGUI;
import mods.immibis.cobaltite.CobaltiteMod.RegisteredTile;
import mods.immibis.core.api.FMLModInfo;
import mods.immibis.core.api.porting.SidedProxy;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PostInit;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;

@Mod(modid="LiquidXP", name = "Liquid XP", version = "55.1.6", dependencies="required-after:ImmibisCore")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
@CobaltiteMod(
	tiles = {
		@RegisteredTile(id="immibis.lxp.collector", tile=CollectorTile.class),
		@RegisteredTile(id="immibis.lxp.absorber", tile=AbsorberTile.class),
		@RegisteredTile(id="immibis.lxp.imprinter", tile=ImprinterTile.class),
		@RegisteredTile(id="immibis.lxp.catalyzer", tile=CatalyzerTile.class),
		@RegisteredTile(id="immibis.lxp.enchanter", tile=EnchanterTile.class),
		@RegisteredTile(id="immibis.lxp.combiner", tile=CombinerTile.class),
		@RegisteredTile(id="immibis.lxp.diverger", tile=IsolatorTile.class)
	}
)
@FMLModInfo(
	description="Liquid XP and related machines.",
	url="http://www.minecraftforum.net/topic/1001131-110-immibiss-mods-smp/",
	authors="immibis"
)
public class LiquidXPMod extends ModBase {
	public static final String FIELD_NAME_recentlyHit = "field_70718_bc";
	
	@AssignedItem(id="liquid")
	public static LiquidItem liquid;
	
	@AssignedItem(id="bucket")
	public static BucketItem bucket;
	
	@AssignedItem(id="medallion")
	public static MedallionItem medallion;
	
	@AssignedBlock(id="machine", item=LXPMachineItem.class)
	public static LXPMachineBlock machines;
	
	@TileGUI(container=ImprinterContainer.class, gui=ImprinterGUI.class)
	public static final int GUI_IMPRINTER = 0;
	
	@TileGUI(container=EnchanterContainer.class, gui=EnchanterGUI.class)
	public static final int GUI_ENCHANTER = 1;
	
	@TileGUI(container=CombinerContainer.class, gui=CombinerGUI.class)
	public static final int GUI_COMBINER = 2;
	
	@TileGUI(container=IsolatorContainer.class, gui=IsolatorGUI.class)
	public static final int GUI_ISOLATOR = 3;
	
	@Instance("LiquidXP")
	public static LiquidXPMod instance;

	@Configurable("onlyEnchantBooks")
	public static boolean ONLY_ENCHANT_BOOKS = true;
	
	@Configurable("destroyXPOverflow")
	public static boolean DESTROY_XP_OVERFLOW = false;
	
	@Configurable("millibucketsPerXPPoint")
	public static int mbPerXp = 25;
	
	@Configurable("xpPerMobEssenceBucket")
	public static int xpPerMobEssenceBucket = 20;
	
	@Configurable("xpPerEnchantingBottle")
	public static int xpPerEnchantingBottle = 13;
	
	@Configurable("xpPerIsolatorOperation")
	public static int xpPerIsolatorOperation = 15;
	
	@Configurable("xpPerCatalyzedMob")
	public static int xpPerCatalyzedMob = 1;
	
	public static LiquidStack liquidDictionaryStack;
	
	public static double convertXPToMB(double xp) {
		return xp * mbPerXp;
	}
	
	public static double convertMBToXP(double mb) {
		return mb / mbPerXp;
	}
	

	@Override
	protected void initBlocksAndItems() throws Exception {
		LiquidContainerRegistry.registerLiquid(new LiquidContainerData(new LiquidStack(liquid, 1000), new ItemStack(bucket), new ItemStack(Item.bucketEmpty)));
		LiquidContainerRegistry.registerLiquid(new LiquidContainerData(new LiquidStack(liquid, (int)convertXPToMB(xpPerEnchantingBottle)), new ItemStack(Item.expBottle), new ItemStack(Item.glassBottle)));
		
		// Liquid name must be unique - if there's another liquid XP mod it may have a
		// different XP/bucket ratio and we don't want them to be interchangeable. 
		LiquidDictionary.getOrCreateLiquid("immibis.liquidxp", new LiquidStack(liquid, 1));
		
		liquidDictionaryStack = LiquidDictionary.getCanonicalLiquid("immibis.liquidxp");
		
		LXP_MFR_Compat.init();
		
		ImprinterTile.initLevelTable();
	}
	
	@Override
	protected void addRecipes() throws Exception {
		GameRegistry.addRecipe(new ItemStack(machines, 1, LXPMachineItem.META_ABSORBER),
			"S_S",
			"SUS",
			"SSS",
			'S', Block.stone,
			'_', Block.pressurePlateStone,
			'U', Item.bucketEmpty
			);
		GameRegistry.addRecipe(new ItemStack(machines, 1, LXPMachineItem.META_CATALYZER),
			"SBS",
			"/D/",
			"D/D",
			'S', Block.stone,
			'D', Item.diamond,
			'/', Item.blazeRod,
			'B', bucket
			);
		GameRegistry.addRecipe(new ItemStack(machines, 1, LXPMachineItem.META_COLLECTOR),
			"SDS",
			"SBS",
			"SSS",
			'S', Block.stone,
			'B', bucket,
			'D', Item.diamond
			);
		GameRegistry.addRecipe(new ItemStack(machines, 1, LXPMachineItem.META_COMBINER),
			"BSB",
			"AFA",
			"SBS",
			'S', Block.stone,
			'B', bucket,
			'F', Block.furnaceIdle,
			'A', Block.anvil
			);
		GameRegistry.addRecipe(new ItemStack(machines, 1, LXPMachineItem.META_ENCHANTER),
			"BDB",
			"OEO",
			"OOO",
			'B', bucket,
			'E', Block.enchantmentTable,
			'D', Item.diamond,
			'O', Block.obsidian
			);
		GameRegistry.addRecipe(new ItemStack(machines, 1, LXPMachineItem.META_IMPRINTER),
			"SMS",
			"BPB",
			"SSS",
			'S', Block.stone,
			'B', Block.bookShelf,
			'P', Block.pistonBase,
			'M', new ItemStack(medallion, 1, 0)
			);
		GameRegistry.addRecipe(new ItemStack(machines, 1, LXPMachineItem.META_ISOLATOR),
			"SDS",
			"BAB",
			"SSS",
			'A', Block.anvil,
			'B', bucket,
			'D', Item.diamond,
			'S', Block.stone
			);
		GameRegistry.addRecipe(new ItemStack(medallion, 1, 0),
			" I ",
			"IBI",
			" I ",
			'I', Item.ingotIron,
			'B', bucket
			);
	}
	
	public static int xpBarCap(int level) {
		return level >= 30 ? 62 + (level - 30) * 7 : (level >= 15 ? 17 + (level - 15) * 3 : 17);
	}
	
	public static int levelToXP(int level) {
		int n = 0;
		for(int k = 0; k < level; k++) // this is not off by one
			n += xpBarCap(k);
		return n;
	}
	
	public static int xpToLevel(int experienceTotal) {
		for(int level = 0; ; level++) {
			experienceTotal -= xpBarCap(level);
			if(experienceTotal < 0)
				return level; // this is not off by one
		}
	}
	
	@Init public void init(FMLInitializationEvent evt) {super._init(evt);}
	@PreInit public void preinit(FMLPreInitializationEvent evt) {
		super._preinit(evt);
		
		if(!SidedProxy.instance.isDedicatedServer())
			ObviousClassUsedForNonMaliciousTrollingOfGreg.preinit();
	}
	
	@PostInit
	public void postinit(FMLPostInitializationEvent evt) {
		if(!SidedProxy.instance.isDedicatedServer())
			ObviousClassUsedForNonMaliciousTrollingOfGreg.postinit();
	}
}
