package mods.immibis.lxp;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class LiquidItem extends Item {
	private static final boolean USE_TEXTURE_FX = false;

	public LiquidItem(int i) {
		super(i);
		
		setUnlocalizedName("immibis/lxp:liquid");
		
		LanguageRegistry.addName(this, "Liquid XP");
		setCreativeTab(CreativeTabs.tabMisc);
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerIcons(IconRegister reg) {
		if(USE_TEXTURE_FX) {
			if(reg instanceof TextureMap) {
				LiquidTextureFX lfx = new LiquidTextureFX("immibis/lxp:liquid");
				itemIcon = lfx;
				((TextureMap)reg).setTextureEntry("immibis/lxp:liquid", lfx);
			}
			else
				itemIcon = Block.blockLapis.getBlockTextureFromSide(0);
			
		} else
		
			itemIcon = reg.registerIcon("immibis/lxp:liquid");
		
		LiquidXPMod.liquidDictionaryStack.setRenderingIcon(itemIcon);
		LiquidXPMod.liquidDictionaryStack.setTextureSheet("/gui/items.png");
	}
}
