package mods.immibis.lxp;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidDictionary.LiquidRegisterEvent;

public class LXP_MFR_Compat {
	public static final String MOB_ESSENCE_NAME = "mobEssence";
	
	public static double convertMobEssenceToLiquidXp(double mb) {
		return LiquidXPMod.convertXPToMB(mb * LiquidXPMod.xpPerMobEssenceBucket / 1000.0);
	}
	
	public static double convertLiquidXpToMobEssence(double mb) {
		return LiquidXPMod.convertMBToXP(mb) / (LiquidXPMod.xpPerMobEssenceBucket / 1000.0);
	}
	
	public static LiquidStack mobEssence;
	
	public static void init() {
		mobEssence = LiquidDictionary.getCanonicalLiquid(MOB_ESSENCE_NAME);
		
		MinecraftForge.EVENT_BUS.register(new EventListener());
	}
	
	public static class EventListener {
		@ForgeSubscribe
		public void onLiquidRegister(LiquidRegisterEvent evt) {
			if(evt.Name.equals(MOB_ESSENCE_NAME) && mobEssence == null)
				mobEssence = LiquidDictionary.getCanonicalLiquid(MOB_ESSENCE_NAME);
		}
	}
}
