package mods.immibis.lxp;

import mods.immibis.core.ItemCombined;

public class LXPMachineItem extends ItemCombined {
	
	public static final int META_COLLECTOR = 0;
	public static final int META_ABSORBER = 1;
	public static final int META_CATALYZER = 2;
	public static final int META_IMPRINTER = 3;
	public static final int META_ENCHANTER = 4;
	public static final int META_COMBINER = 5;
	public static final int META_RENAMER = 6;
	public static final int META_ISOLATOR = 7;

	public LXPMachineItem(int n) {
		super(n, new String[] {
			"LXP Collector", // XP orb -> LXP
			"LXP Absorber", // player XP -> LXP
			"LXP Catalyzer", // nearby mob deaths always drop XP
			"LXP Imprinter", // LXP + blank medallions -> imprinted medallions
			"LXP Enchanter", // imprinted medallions + books + small XP -> blank medallions + enchanted books
			"LXP Combiner", // anvil combining function
			"LXP Renamer", // anvil renaming function
			"LXP Isolator" 
		});
	}

}
