package mods.immibis.lxp;


import java.util.ArrayList;

import mods.immibis.core.BlockCombined;
import mods.immibis.core.api.util.Dir;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class LXPMachineBlock extends BlockCombined {

	public LXPMachineBlock(int i) {
		super(i, Material.iron, "immibis/lxp", new String[] {"collector", "absorber", "catalyzer", "imprinter", "enchanter", "combiner", "diverger"});
	}
	
	private Icon iCatl, iColl, iGenericGrille, iCombFront, iCombSide;
	private Icon iEnchBottom, iEnchFront, iEnchSide, iEnchTop, iGenericSide, iImprFront, iAbsoTop;
	private Icon iDivgFront, iDivgSide;
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerIcons(IconRegister reg) {
		iCatl			= reg.registerIcon("immibis/lxp:catalyzer");
		iColl			= reg.registerIcon("immibis/lxp:collector");
		iGenericGrille	= reg.registerIcon("immibis/lxp:generic-grille");
		iCombFront		= reg.registerIcon("immibis/lxp:combiner-front");
		iCombSide		= reg.registerIcon("immibis/lxp:combiner-side");
		iEnchBottom		= reg.registerIcon("immibis/lxp:enchanter-bottom");
		iEnchFront		= reg.registerIcon("immibis/lxp:enchanter-front");
		iEnchSide		= reg.registerIcon("immibis/lxp:enchanter-side");
		iEnchTop		= reg.registerIcon("immibis/lxp:enchanter-top");
		iGenericSide	= reg.registerIcon("immibis/lxp:generic-side");
		iImprFront		= reg.registerIcon("immibis/lxp:imprinter-front");
		iAbsoTop		= reg.registerIcon("immibis/lxp:absorber-top");
		iDivgFront		= reg.registerIcon("immibis/lxp:diverger-front");
		iDivgSide		= reg.registerIcon("immibis/lxp:diverger-side");
	}

	@Override
	public Icon getIcon(int side, int data) {
		switch(data) {
		case LXPMachineItem.META_COLLECTOR: return iColl;
		case LXPMachineItem.META_ABSORBER: return side == Dir.PY ? iAbsoTop : iGenericSide;
		case LXPMachineItem.META_CATALYZER: return iCatl;
		case LXPMachineItem.META_IMPRINTER: return side == Dir.PY || side == Dir.NY ? iGenericGrille : iImprFront;
		case LXPMachineItem.META_ENCHANTER:
			if(side == Dir.PZ)
				return iEnchFront;
			if(side == Dir.PY)
				return iEnchTop;
			if(side == Dir.NY)
				return iEnchBottom;
			return iEnchSide;
		case LXPMachineItem.META_COMBINER:
			if(side == Dir.PY || side == Dir.NY)
				return iGenericSide;
			if(side == Dir.NZ)
				return iGenericGrille;
			if(side == Dir.PZ)
				return iCombFront;
			return iCombSide;
		case LXPMachineItem.META_ISOLATOR:
			if(side == Dir.PY || side == Dir.NY)
				return iGenericSide;
			if(side == Dir.NZ)
				return iGenericGrille;
			if(side == Dir.PZ)
				return iDivgFront;
			return iDivgSide;
		}
		return null;
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public Icon getBlockTexture(IBlockAccess w, int x, int y, int z, int side) {
		TileEntity te = w.getBlockTileEntity(x, y, z);
		if(te instanceof EnchanterTile) {
			int front = ((EnchanterTile)te).front;
			if(side == front)
				return iEnchFront;
			if(side == Dir.PY)
				return iEnchTop;
			if(side == Dir.NY)
				return iEnchBottom;
			return iEnchSide;
		}
		if(te instanceof CombinerTile) {
			int front = ((CombinerTile)te).front;
			if(side == front)
				return iCombFront;
			if(side == (front ^ 1))
				return iGenericGrille;
			if(side == Dir.PY || side == Dir.NY)
				return iGenericSide;
			return iCombSide;
		}
		if(te instanceof IsolatorTile) {
			int front = ((IsolatorTile)te).front;
			if(side == front)
				return iDivgFront;
			if(side == (front ^ 1))
				return iGenericGrille;
			if(side == Dir.PY || side == Dir.NY)
				return iGenericSide;
			return iDivgSide;
		}
		
		return super.getBlockTexture(w, x, y, z, side);
	}

	@Override
	public TileEntity getBlockEntity(int data) {
		switch(data) {
		case LXPMachineItem.META_COLLECTOR: return new CollectorTile();
		case LXPMachineItem.META_ABSORBER: return new AbsorberTile();
		case LXPMachineItem.META_CATALYZER: return new CatalyzerTile();
		case LXPMachineItem.META_IMPRINTER: return new ImprinterTile();
		case LXPMachineItem.META_ENCHANTER: return new EnchanterTile();
		case LXPMachineItem.META_COMBINER: return new CombinerTile();
		case LXPMachineItem.META_ISOLATOR: return new IsolatorTile();
		}
		return null;
	}

	@SuppressWarnings({"rawtypes","unchecked"})
	@Override
	public void addCreativeItems(ArrayList arraylist) {
		arraylist.add(new ItemStack(this, 1, LXPMachineItem.META_COLLECTOR));
		arraylist.add(new ItemStack(this, 1, LXPMachineItem.META_ABSORBER));
		arraylist.add(new ItemStack(this, 1, LXPMachineItem.META_CATALYZER));
		arraylist.add(new ItemStack(this, 1, LXPMachineItem.META_IMPRINTER));
		arraylist.add(new ItemStack(this, 1, LXPMachineItem.META_ENCHANTER));
		arraylist.add(new ItemStack(this, 1, LXPMachineItem.META_COMBINER));
		arraylist.add(new ItemStack(this, 1, LXPMachineItem.META_ISOLATOR));
	}

}
