package mods.immibis.lxp;

import mods.immibis.core.TileCombined;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class LXPAcceptingTile extends TileCombined implements ITankContainer, ILiquidTank {
	protected double storedLiquid = 0; // can be negative
	protected int capacity;
	protected boolean acceptingLXP = true;
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		tag.setDouble("stored", storedLiquid);
		tag.setInteger("capacity", capacity);
		tag.setBoolean("accept", acceptingLXP);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		
		NBTBase b = tag.getTag("stored");
		if(b instanceof NBTTagDouble)
			storedLiquid = tag.getDouble("stored");
		else
			storedLiquid = tag.getInteger("stored");
		
		capacity = tag.getInteger("capacity");
		acceptingLXP = tag.getBoolean("accept") || !tag.hasKey("accept");
	}

	@Override
	public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
		return fill(resource, doFill);
	}

	@Override
	public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
		return fill(resource, doFill);
	}

	@Override
	public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
		return drain(maxDrain, doDrain);
	}

	@Override
	public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
		return drain(maxDrain, doDrain);
	}
	
	private ILiquidTank[] tanks = {this};
	@Override
	public ILiquidTank[] getTanks(ForgeDirection direction) {
		return tanks;
	}

	@Override
	public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
		return this;
	}

	@Override
	public LiquidStack getLiquid() {
		if(storedLiquid < 1)
			return null;
		return new LiquidStack(LiquidXPMod.liquid, (int)storedLiquid);
	}

	@Override
	public int getCapacity() {
		return capacity;
	}

	@Override
	public int fill(LiquidStack resource, boolean doFill) {
		if(!acceptingLXP)
			return 0;
		
		if(resource.itemID == LiquidXPMod.liquid.itemID) {
			int toFill = Math.min(resource.amount, (int)(capacity - storedLiquid));
			if(doFill)
				storedLiquid += toFill;
			return toFill;
		}
		
		if(LXP_MFR_Compat.mobEssence != null && LXP_MFR_Compat.mobEssence.isLiquidEqual(resource)) {
			
			// extra Math.random() makes it average out correct, even if millibucket amount is truncated
			// e.g. if it ends up at 1.75 mB of LXP, then 75% of the time it will be worth 2 mB, and 25% of the time 1 mB.
			int equivLXP = (int)(LXP_MFR_Compat.convertMobEssenceToLiquidXp(resource.amount));
			
			int toFillLXP = Math.min(equivLXP, (int)(capacity - storedLiquid));
			if(doFill)
				storedLiquid += toFillLXP;
			
			return (int)Math.ceil(LXP_MFR_Compat.convertLiquidXpToMobEssence(equivLXP));
		}
		
		return 0;
	}

	@Override
	public LiquidStack drain(int maxDrain, boolean doDrain) {
		return null;
	}

	@Override
	public int getTankPressure() {
		return -50;
	}
}
