package mods.immibis.tubestuff;

import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

import mods.immibis.core.api.util.BaseGuiContainer;

public class GuiMCT2Edit extends BaseGuiContainer<ContainerMCT2Edit> {
	
	private static final boolean SNAPPY_SCROLLING = false;
	
	private float scrollPos; // measured in recipes

	public GuiMCT2Edit(ContainerMCT2Edit c) {
		super(c, 186, 215, "/mods/immibis/tubestuff/gui/mct2-gui.png");
	}
	
	@Override
	protected void drawGuiContainerBackgroundLayer(float var1, int x, int y) {
		x -= guiLeft; y -= guiTop;
		
		mc.renderEngine.bindTexture("/mods/immibis/tubestuff/gui/mct2-gui.png");
		GL11.glColor3f(1, 1, 1);
		
		GL11.glPushMatrix();
		GL11.glTranslatef(guiLeft, guiTop, 0);
		
		// draw scrollable area background
		drawTexturedModalRect(13, 10, 13, 69, 148, 59);
		drawTexturedModalRect(13, 69, 13, 69, 148, 59);
		
		// draw recipes
		for(int k = 0; k < container.numRecipes; k++) {
			//int pos = k - (int)Math.floor(scrollPos);
			//if(pos >= 0 && pos < 2)
				drawTexturedModalRect(13, 10 + (int)((k - scrollPos) * 59), 13, 10, 148, 59);
			/*else if(pos < 0) {
				int scaleInv = 4;
				float scale = 1.0f / scaleInv;
				
				int index = -pos - 1;
				int height = (ySize * scaleInv) / 59;
				
				int iy = index % height;
				int ix = -(index / height) - 1;
				
				GL11.glPushMatrix();
				GL11.glScalef(scale, scale, 1);
				drawTexturedModalRect(ix * 148, iy * 59, 13, 10, 148, 59);
				GL11.glPopMatrix();
			} else if(pos >= 2) {
				int scaleInv = 4;
				float scale = 1.0f / scaleInv;
				
				int index = pos - 2;
				int height = (ySize * scaleInv) / 59;
				
				int iy = index % height;
				int ix = index / height;
				
				GL11.glPushMatrix();
				GL11.glScalef(scale, scale, 1);
				drawTexturedModalRect((xSize + 1)*scaleInv + ix * 148, iy * 59, 13, 10, 148, 59);
				GL11.glPopMatrix();
			}*/
		}
		
		// draw everything around the scrollable area
		drawTexturedModalRect(0, 0, 0, 0, 186, 10);
		drawTexturedModalRect(0, 10, 0, 10, 13, 205);
		drawTexturedModalRect(13, 128, 13, 128, 173, 87);
		drawTexturedModalRect(161, 10, 161, 10, 25, 118);
		
		// draw and process scrollbar
		{
			int maxScroll = Math.max(0, container.numRecipes - 2);
			if(Mouse.isButtonDown(0) && x >= 164 && y >= 0 && x < 173 && y < 138) {
				float temp = (y - 10) / 118.0f * maxScroll;
				
				scrollPos = SNAPPY_SCROLLING ? (int)(temp + 0.5f) : temp;
			}
			scrollPos = Math.max(0, Math.min(scrollPos, maxScroll));
			drawTexturedModalRect(164, 10 + (int)(scrollPos * 107 / maxScroll), 186, 0, 9, 11);
		}
		
		GL11.glPopMatrix();
	}
}
