/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.core.IC2;
import ic2.core.util.StackUtil;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricItemManager
implements IElectricItemManager {
    @Override
    public int charge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        if (amount < 0 || itemStack.field_77994_a > 1 || item.getTier(itemStack) > tier) {
            return 0;
        }
        if (amount > item.getTransferLimit(itemStack) && !ignoreTransferLimit) {
            amount = item.getTransferLimit(itemStack);
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        int charge = nbtData.func_74762_e("charge");
        if (amount > item.getMaxCharge(itemStack) - charge) {
            amount = item.getMaxCharge(itemStack) - charge;
        }
        charge += amount;
        if (!simulate) {
            nbtData.func_74768_a("charge", charge);
            int n = itemStack.field_77993_c = charge > 0 ? item.getChargedItemId(itemStack) : item.getEmptyItemId(itemStack);
            if (itemStack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)itemStack.func_77973_b();
                if (itemStack.func_77958_k() > 2) {
                    itemStack.func_77964_b(1 + (item.getMaxCharge(itemStack) - charge) * (itemStack.func_77958_k() - 2) / item.getMaxCharge(itemStack));
                } else {
                    itemStack.func_77964_b(0);
                }
            } else {
                itemStack.func_77964_b(0);
            }
        }
        return amount;
    }

    @Override
    public int discharge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound nbtData;
        int charge;
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        if (amount < 0 || itemStack.field_77994_a > 1 || item.getTier(itemStack) > tier) {
            return 0;
        }
        if (amount > item.getTransferLimit(itemStack) && !ignoreTransferLimit) {
            amount = item.getTransferLimit(itemStack);
        }
        if (amount > (charge = (nbtData = StackUtil.getOrCreateNbtData(itemStack)).func_74762_e("charge"))) {
            amount = charge;
        }
        if (!simulate) {
            nbtData.func_74768_a("charge", charge -= amount);
            int n = itemStack.field_77993_c = charge > 0 ? item.getChargedItemId(itemStack) : item.getEmptyItemId(itemStack);
            if (itemStack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)itemStack.func_77973_b();
                if (itemStack.func_77958_k() > 2) {
                    itemStack.func_77964_b(1 + (item.getMaxCharge(itemStack) - charge) * (itemStack.func_77958_k() - 2) / item.getMaxCharge(itemStack));
                } else {
                    itemStack.func_77964_b(0);
                }
            } else {
                itemStack.func_77964_b(0);
            }
        }
        return amount;
    }

    @Override
    public int getCharge(ItemStack itemStack) {
        return ElectricItem.manager.discharge(itemStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
    }

    @Override
    public boolean canUse(ItemStack itemStack, int amount) {
        return ElectricItem.manager.getCharge(itemStack) >= amount;
    }

    @Override
    public boolean use(ItemStack itemStack, int amount, EntityLiving entity) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        ElectricItem.manager.chargeFromArmor(itemStack, entity);
        int transfer = ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, true);
        if (transfer == amount) {
            ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false);
            ElectricItem.manager.chargeFromArmor(itemStack, entity);
            return true;
        }
        return false;
    }

    @Override
    public void chargeFromArmor(ItemStack itemStack, EntityLiving entity) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        boolean inventoryChanged = false;
        for (int i = 0; i < 4; ++i) {
            IElectricItem armorItem;
            ItemStack armorItemStack = entity.func_82169_q(i);
            if (armorItemStack == null || !(armorItemStack.func_77973_b() instanceof IElectricItem) || !(armorItem = (IElectricItem)armorItemStack.func_77973_b()).canProvideEnergy(armorItemStack) || armorItem.getTier(armorItemStack) < ((IElectricItem)itemStack.func_77973_b()).getTier(itemStack)) continue;
            int transfer = ElectricItem.manager.charge(itemStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
            if ((transfer = ElectricItem.manager.discharge(armorItemStack, transfer, Integer.MAX_VALUE, true, false)) <= 0) continue;
            ElectricItem.manager.charge(itemStack, transfer, Integer.MAX_VALUE, true, false);
            inventoryChanged = true;
        }
        if (inventoryChanged && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_71070_bA.func_75142_b();
        }
    }

    @Override
    public String getToolTip(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof IElectricItem)) {
            return null;
        }
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        return ElectricItem.manager.getCharge(itemStack) + "/" + item.getMaxCharge(itemStack) + " EU";
    }
}

