/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityMagnetizer
extends TileEntityBlock
implements IEnergySink {
    public int energy = 0;
    public int ticker = 0;
    public int maxEnergy = 100;
    public int maxInput = 32;
    public boolean addedToEnergyNet = false;

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", (short)this.energy);
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void func_70316_g() {
        int need;
        int y;
        super.func_70316_g();
        if (this.ticker-- > 0) {
            return;
        }
        boolean change = false;
        for (y = this.field_70330_m - 1; y > 0 && y >= this.field_70330_m - 20 && this.energy > 0 && this.field_70331_k.func_72798_a(this.field_70329_l, y, this.field_70327_n) == Ic2Items.ironFence.field_77993_c; --y) {
            need = 15 - this.field_70331_k.func_72805_g(this.field_70329_l, y, this.field_70327_n);
            if (need <= 0) continue;
            change = true;
            if (need > this.energy) {
                this.energy = need;
            }
            this.field_70331_k.func_72921_c(this.field_70329_l, y, this.field_70327_n, this.field_70331_k.func_72805_g(this.field_70329_l, y, this.field_70327_n) + need, 7);
            this.energy -= need;
        }
        for (y = this.field_70330_m + 1; y < IC2.getWorldHeight(this.field_70331_k) && y <= this.field_70330_m + 20 && this.energy > 0 && this.field_70331_k.func_72798_a(this.field_70329_l, y, this.field_70327_n) == Ic2Items.ironFence.field_77993_c; ++y) {
            need = 15 - this.field_70331_k.func_72805_g(this.field_70329_l, y, this.field_70327_n);
            if (need <= 0) continue;
            change = true;
            if (need > this.energy) {
                this.energy = need;
            }
            this.field_70331_k.func_72921_c(this.field_70329_l, y, this.field_70327_n, this.field_70331_k.func_72805_g(this.field_70329_l, y, this.field_70327_n) + need, 7);
            this.energy -= need;
        }
        if (!change) {
            this.ticker = 10;
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    @Override
    public int demandsEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            IC2.explodeMachineAt(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return 0;
        }
        if (this.energy >= this.maxEnergy) {
            return amount;
        }
        this.energy += amount;
        return 0;
    }

    @Override
    public int getMaxSafeInput() {
        return this.maxInput;
    }
}

