/*
 * Decompiled with CFR 0.152.
 */
package cofh.util.inventory;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class InventorySimple
implements IInventory {
    public ItemStack[] myStacks;
    public String myName = null;

    public InventorySimple(int size) {
        this.myStacks = new ItemStack[size];
    }

    public InventorySimple(int size, String invName) {
        this(size);
        this.myName = invName;
    }

    public void dropInventoryIntoWorld(TileEntity theTile) {
        this.dropInventoryIntoWorld(theTile.field_70331_k, theTile.field_70329_l, theTile.field_70330_m, theTile.field_70327_n);
    }

    public void dropInventoryIntoWorld(World theWorld, int x, int y, int z) {
        for (int n = 0; n < this.func_70302_i_(); ++n) {
            ItemStack stack = this.func_70301_a(n);
            if (stack == null) continue;
            float x2 = theWorld.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float y2 = theWorld.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float z2 = theWorld.field_73012_v.nextFloat() * 0.8f + 0.1f;
            int size = stack.field_77994_a;
            stack.field_77994_a -= size;
            EntityItem entity = new EntityItem(theWorld, (double)((float)x + x2), (double)((float)y + y2), (double)((float)z + z2), new ItemStack(stack.field_77993_c, size, stack.func_77960_j()));
            if (stack.func_77942_o()) {
                entity.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            entity.field_70159_w = (float)theWorld.field_73012_v.nextGaussian() * 0.05f;
            entity.field_70181_x = (float)theWorld.field_73012_v.nextGaussian() * 0.05f + 0.2f;
            entity.field_70179_y = (float)theWorld.field_73012_v.nextGaussian() * 0.05f;
            theWorld.func_72838_d((Entity)entity);
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        NBTTagList list = data.func_74761_m("inventory");
        this.myStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = (NBTTagCompound)list.func_74743_b(i);
            int slot = compound.func_74762_e("slot");
            if (slot < 0 || slot >= this.myStacks.length) continue;
            this.myStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.myStacks[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("slot", i);
            this.myStacks[i].func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        data.func_74782_a("inventory", (NBTBase)list);
    }

    public void readFromNBT(ItemStack anItem, String tagName) {
        if (anItem.field_77990_d != null && anItem.field_77990_d.func_74764_b(tagName)) {
            this.readFromNBT(anItem.field_77990_d.func_74775_l(tagName));
        }
    }

    public void writeToNBT(ItemStack anItem, String tagName) {
        if (anItem.field_77990_d == null) {
            anItem.field_77990_d = new NBTTagCompound();
        }
        if (!anItem.field_77990_d.func_74764_b(tagName)) {
            anItem.field_77990_d.func_74782_a(tagName, (NBTBase)new NBTTagCompound());
        }
        this.writeToNBT(anItem.field_77990_d.func_74775_l(tagName));
    }

    public int func_70302_i_() {
        return this.myStacks.length;
    }

    public ItemStack func_70301_a(int var1) {
        if (var1 < this.func_70302_i_()) {
            return this.myStacks[var1];
        }
        return null;
    }

    public ItemStack func_70298_a(int var1, int var2) {
        if (var1 < this.func_70302_i_() && this.myStacks[var1] != null) {
            if (this.myStacks[var1].field_77994_a <= var2) {
                ItemStack returnStack = this.myStacks[var1];
                this.myStacks[var1] = null;
                return returnStack;
            }
            ItemStack returnStack = this.myStacks[var1].func_77979_a(var2);
            if (this.myStacks[var1].field_77994_a <= 0) {
                this.myStacks[var1] = null;
            }
            return returnStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        if (var1 < this.func_70302_i_()) {
            return this.myStacks[var1];
        }
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        if (var1 < this.func_70302_i_()) {
            this.myStacks[var1] = var2;
        }
    }

    public String func_70303_b() {
        return this.myName;
    }

    public boolean func_94042_c() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }
}

