/*
 * Decompiled with CFR 0.152.
 */
package cofh.skins;

import cofh.CoFHCore;
import cofh.api.core.ISimpleRegistry;
import cofh.network.PacketCoFH;
import cofh.skins.SkinPacketHandler;
import cofh.util.CoreUtils;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.StringUtils;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class CapeHandler
implements ISimpleRegistry {
    private static HashMap capeMap = new HashMap();
    public static boolean allowPlayersUse = true;
    public static boolean allowOpsUse = true;
    public static boolean allowOpsOthers = false;
    public static Configuration capeConf;

    public static boolean registerCape(String playerName, String capeURL, boolean saveToFile) {
        if (playerName == null || capeURL == null) {
            return false;
        }
        playerName = playerName.toLowerCase();
        capeMap.put(playerName, capeURL);
        if (saveToFile) {
            capeConf.get("links", playerName, capeURL);
            capeConf.save();
        }
        return true;
    }

    public static boolean removeCape(String playerName, boolean removeFromFile) {
        if (playerName == null) {
            return false;
        }
        playerName = playerName.toLowerCase();
        capeMap.remove(playerName);
        if (removeFromFile) {
            if (capeConf.hasCategory("links")) {
                capeConf.getCategory("links").remove((Object)playerName);
                capeConf.save();
            } else {
                CapeHandler.registerDefaults();
                return false;
            }
        }
        CapeHandler.registerDefaults();
        return true;
    }

    public static void loadCapes() {
        if (!capeConf.hasCategory("links")) {
            return;
        }
        for (String name : capeConf.getCategory("links").keySet()) {
            Property curCape = capeConf.getCategory("links").get(name);
            CapeHandler.registerCape(name, curCape.getString(), false);
        }
        CoFHCore.log.info("Loaded " + capeConf.getCategory("links").keySet().size() + " capes.");
    }

    public static String getPlayerCape(String playerName) {
        if (playerName == null || !capeMap.containsKey(playerName.toLowerCase())) {
            return null;
        }
        return (String)capeMap.get(playerName.toLowerCase());
    }

    public static void handlePlayerChange(EntityPlayer player) {
        if (CoFHCore.proxy.isServer()) {
            return;
        }
        String newCape = CapeHandler.getPlayerCape(player.field_71092_bJ);
        if (newCape != null && newCape != player.field_70119_cs) {
            player.field_70119_cs = newCape;
            CoFHCore.proxy.obtainImage(player.field_70119_cs);
        } else if (newCape == null) {
            player.field_70119_cs = "http://skins.minecraft.net/MinecraftCloaks/" + StringUtils.func_76338_a((String)player.field_71092_bJ) + ".png";
        }
    }

    public static void handlePlayerChange(String playerName) {
        if (playerName == null || playerName.equals("") || CoFHCore.proxy.isServer()) {
            return;
        }
        EntityPlayer player = CoFHCore.proxy.findPlayer(playerName);
        if (player != null) {
            CapeHandler.handlePlayerChange(player);
        }
    }

    public static boolean playerCanAccess(String playerName) {
        return allowPlayersUse ? true : allowOpsUse && CoreUtils.isOp(playerName);
    }

    public static boolean playerCanSetOthers(String playerName) {
        return allowOpsOthers && CoreUtils.isOp(playerName) && (allowPlayersUse || allowOpsUse);
    }

    public static void readJoinPacket(DataInputStream data) {
        try {
            capeMap = new HashMap();
            int count = data.readByte();
            for (int i = 0; i < count; ++i) {
                String name = data.readUTF();
                String link = data.readUTF();
                CapeHandler.registerCape(name, link, false);
            }
        }
        catch (IOException e) {
            CoFHCore.log.log(Level.SEVERE, "Packet Payload Failure. ID: CJ");
        }
    }

    public static void readAddPacket(DataInputStream data) {
        try {
            String name = data.readUTF();
            String link = data.readUTF();
            CapeHandler.registerCape(name, link, false);
            CapeHandler.handlePlayerChange(name);
        }
        catch (IOException e) {
            CoFHCore.log.log(Level.SEVERE, "Packet Payload Failure. ID: CA");
        }
    }

    public static void sendJoinPacket(EntityPlayer player) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        int sendCount = 0;
        try {
            int i;
            List players = CoFHCore.proxy.getPlayerList();
            if (players.size() <= 0) {
                return;
            }
            for (i = 0; i < players.size(); ++i) {
                if (CapeHandler.getPlayerCape(((EntityPlayer)players.get((int)i)).field_71092_bJ) == null) continue;
                ++sendCount;
            }
            data.writeByte(SkinPacketHandler.Type.CAPE_JOIN.ordinal());
            data.writeByte(sendCount);
            for (i = 0; i < players.size(); ++i) {
                if (CapeHandler.getPlayerCape(((EntityPlayer)players.get((int)i)).field_71092_bJ) == null) continue;
                data.writeUTF(((EntityPlayer)players.get((int)i)).field_71092_bJ);
                data.writeUTF(CapeHandler.getPlayerCape(((EntityPlayer)players.get((int)i)).field_71092_bJ));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (sendCount == 0) {
            return;
        }
        PacketDispatcher.sendPacketToPlayer((Packet)PacketCoFH.getTinyPacket(SkinPacketHandler.myPacketID, bytes), (Player)((Player)player));
    }

    public static void sendAddPacket(String playerUsername) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            if (CapeHandler.getPlayerCape(playerUsername) == null) {
                return;
            }
            data.writeByte(SkinPacketHandler.Type.CAPE_ADD.ordinal());
            data.writeUTF(playerUsername);
            data.writeUTF(CapeHandler.getPlayerCape(playerUsername));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)PacketCoFH.getTinyPacket(SkinPacketHandler.myPacketID, bytes));
    }

    public static void readRemovePacket(DataInputStream data) {
        try {
            String name = data.readUTF();
            CapeHandler.removeCape(name, false);
            CapeHandler.handlePlayerChange(name);
        }
        catch (IOException e) {
            CoFHCore.log.log(Level.SEVERE, "Packet Payload Failure. ID: CR");
        }
    }

    public static void sendRemovePacket(String playerUsername) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeByte(SkinPacketHandler.Type.CAPE_REMOVE.ordinal());
            data.writeUTF(playerUsername);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)PacketCoFH.getTinyPacket(SkinPacketHandler.myPacketID, bytes));
    }

    public static void registerDefaults() {
        CapeHandler.registerCape("kingLemmingcofh", "https://dl.dropbox.com/u/57416963/Minecraft/Capes/kinglemmingcofh.png", false);
        CapeHandler.registerCape("zeldokavira", "https://dl.dropbox.com/u/27292492/cape/zeldo.png", false);
        CapeHandler.registerCape("jadedcat", "https://dl.dropbox.com/u/57416963/Minecraft/Capes/jadedcat.png", false);
    }

    @Override
    public boolean register(String playerName, String capeURL) {
        return CapeHandler.registerCape(playerName, capeURL, false);
    }
}

