/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.netherores.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import powercrystals.netherores.NetherOresCore;
import powercrystals.netherores.ores.Ores;
import powercrystals.netherores.world.WorldGenNetherOres;

public class NetherOresWorldGenHandler
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == -1 || NetherOresCore.worldGenAllDimensions.getBoolean(false)) {
            this.generateNether(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateNether(World world, Random random, int chunkX, int chunkZ) {
        for (Ores o : Ores.values()) {
            if (!o.isRegisteredSmelting() && !o.isRegisteredMacerator() && !NetherOresCore.forceOreSpawn.getBoolean(false) || o.getDisabled()) continue;
            for (int i = 0; i < o.getGroupsPerChunk(); ++i) {
                int x = chunkX + random.nextInt(16);
                int y = o.getMinY() + random.nextInt(o.getMaxY() - o.getMinY());
                int z = chunkZ + random.nextInt(16);
                new WorldGenNetherOres(NetherOresCore.getOreBlock((int)o.getBlockIndex()).field_71990_ca, o.getMetadata(), o.getBlocksPerGroup()).func_76484_a(world, random, x, y, z);
            }
        }
        if (NetherOresCore.enableHellfish.getBoolean(true)) {
            for (int i = 0; i < 9; ++i) {
                int x = chunkX + random.nextInt(16);
                int y = random.nextInt(128);
                int z = chunkZ + random.nextInt(16);
                new WorldGenNetherOres(NetherOresCore.blockHellfish.field_71990_ca, 0, 12).func_76484_a(world, random, x, y, z);
            }
        }
    }
}

