/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.netherores.ores;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import powercrystals.netherores.NetherOresCore;
import powercrystals.netherores.entity.EntityArmedOre;
import powercrystals.netherores.gui.NOCreativeTab;
import powercrystals.netherores.ores.Ores;

public class BlockNetherOres
extends Block {
    private static int _aggroRange = 32;
    private int _blockIndex = 0;
    private Icon[] _netherOresIcons = new Icon[16];

    public BlockNetherOres(int blockId, int blockIndex) {
        super(blockId, Block.field_72012_bb.field_72018_cp);
        this.func_71848_c(5.0f);
        this.func_71894_b(1.0f);
        this.func_71864_b("netherores.ore." + blockIndex);
        this.func_71884_a(field_71976_h);
        this.func_71849_a(NOCreativeTab.tab);
        this._blockIndex = blockIndex;
    }

    public int getBlockIndex() {
        return this._blockIndex;
    }

    public void func_94332_a(IconRegister ir) {
        Ores[] ores = Ores.values();
        int e = Math.min(this._blockIndex * 16 + 15, ores.length - 1) % 16;
        for (int i = 0; i <= e; ++i) {
            this._netherOresIcons[i] = ir.func_94245_a("powercrystals/netherores/" + this.func_71917_a() + "_" + i);
        }
    }

    public Icon func_71858_a(int side, int meta) {
        return this._netherOresIcons[meta];
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public int func_71925_a(Random random) {
        return 1;
    }

    public void func_71893_a(World world, EntityPlayer entityplayer, int x, int y, int z, int fortune) {
        super.func_71893_a(world, entityplayer, x, y, z, fortune);
        if (NetherOresCore.enableAngryPigmen.getBoolean(true)) {
            this.angerPigmen(entityplayer, world, x, y, z);
        }
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (player == null || !EnchantmentHelper.func_77502_d((EntityLiving)player)) {
            this.checkExplosionChances(world, x, y, z);
        }
        return super.removeBlockByPlayer(world, player, x, y, z);
    }

    public void func_71867_k(World world, int x, int y, int z, Explosion explosion) {
        if (NetherOresCore.enableExplosionChainReactions.getBoolean(true)) {
            this.checkExplosionChances(world, x, y, z);
        }
    }

    private void checkExplosionChances(World world, int x, int y, int z) {
        if (!world.field_72995_K && NetherOresCore.enableExplosions.getBoolean(true)) {
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                    for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                        int tx = x + xOffset;
                        int ty = y + yOffset;
                        int tz = z + zOffset;
                        if (tx == x && ty == y && tz == z || world.func_72798_a(tx, ty, tz) != this.field_71990_ca || world.field_73012_v.nextInt(1000) >= NetherOresCore.explosionProbability.getInt()) continue;
                        EntityArmedOre eao = new EntityArmedOre(world, (double)tx + 0.5, (double)ty + 0.5, (double)tz + 0.5);
                        world.func_72838_d((Entity)eao);
                        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fuse", 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    private void angerPigmen(EntityPlayer player, World world, int x, int y, int z) {
        List list = world.func_72872_a(EntityPigZombie.class, AxisAlignedBB.func_72330_a((double)(x - _aggroRange), (double)(y - _aggroRange), (double)(z - _aggroRange), (double)(x + _aggroRange + 1), (double)(y + _aggroRange + 1), (double)(z + _aggroRange + 1)));
        for (int j = 0; j < list.size(); ++j) {
            Entity entity1 = (Entity)list.get(j);
            if (!(entity1 instanceof EntityPigZombie)) continue;
            EntityPigZombie entitypigzombie = (EntityPigZombie)entity1;
            entitypigzombie.func_70835_c((Entity)player);
        }
    }
}

