/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.liquid;

import codechicken.core.ClientUtils;
import codechicken.core.ServerUtils;
import codechicken.core.alg.MathHelper;
import codechicken.core.liquid.LiquidUtils;
import codechicken.core.packet.PacketCustom;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.storage.liquid.EnderLiquidStorage;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.liquids.LiquidStack;

public class TankSynchroniser
implements IPlayerTracker,
ITickHandler {
    private static HashMap playerItemTankStates;
    private static PlayerItemTankCache clientState;

    public static String key(int freq, String owner) {
        return String.valueOf(freq) + "|" + owner;
    }

    public static int splitKeyF(String s) {
        return Integer.parseInt(s.substring(0, s.indexOf(124)));
    }

    public static String splitKeyS(String s) {
        return s.substring(s.indexOf(124) + 1, s.length());
    }

    public static void syncClient(int freq, String owner, LiquidStack liquid) {
        clientState.sync(freq, owner, liquid);
    }

    public static LiquidStack getClientLiquid(int freq, String owner) {
        return clientState.getLiquid(freq, owner);
    }

    public static void handleVisiblityPacket(jc player, PacketCustom packet) {
        ((PlayerItemTankCache)playerItemTankStates.get(player.bS)).handleVisiblityPacket(packet);
    }

    public void onPlayerLogin(sq player) {
        playerItemTankStates.put(player.bS, new PlayerItemTankCache((jc)player));
    }

    public void onPlayerLogout(sq player) {
        playerItemTankStates.remove(player.bS);
    }

    public void onPlayerChangedDimension(sq player) {
        playerItemTankStates.put(player.bS, new PlayerItemTankCache((jc)player));
    }

    public void onPlayerRespawn(sq player) {
    }

    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.CLIENT) && ClientUtils.inWorld()) {
            clientState.update();
        }
        if (type.contains(TickType.SERVER)) {
            for (Map.Entry entry : playerItemTankStates.entrySet()) {
                ((PlayerItemTankCache)entry.getValue()).update();
            }
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.SERVER, TickType.CLIENT);
    }

    public String getLabel() {
        return "EnderStorage tank Synchronisation";
    }

    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.world.I && !ServerUtils.mc().m()) {
            playerItemTankStates = null;
        }
    }

    @ForgeSubscribe
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.I) {
            clientState = new PlayerItemTankCache();
        } else if (playerItemTankStates == null) {
            playerItemTankStates = new HashMap();
        }
    }

    public static class PlayerItemTankCache {
        private boolean client;
        private HashMap tankStates = new HashMap();
        private HashSet b_visible;
        private HashSet a_visible;
        private jc player;

        public PlayerItemTankCache(jc player) {
            this.player = player;
            this.client = false;
        }

        public PlayerItemTankCache() {
            this.client = true;
            this.a_visible = new HashSet();
            this.b_visible = new HashSet();
        }

        public void track(int freq, String owner, boolean t) {
            String key = TankSynchroniser.key(freq, owner);
            PlayerItemTankState state = (PlayerItemTankState)this.tankStates.get(key);
            if (state == null) {
                if (!t) {
                    return;
                }
                state = new PlayerItemTankState(this.player, (EnderLiquidStorage)EnderStorageManager.instance(false).getStorage(owner, freq, "liquid"));
                this.tankStates.put(key, state);
            }
            state.setTracking(t);
        }

        public void sync(int freq, String owner, LiquidStack liquid) {
            String key = TankSynchroniser.key(freq, owner);
            PlayerItemTankState state = (PlayerItemTankState)this.tankStates.get(key);
            if (state == null) {
                state = new PlayerItemTankState();
                this.tankStates.put(key, state);
            }
            state.sync(liquid);
        }

        public void update() {
            for (Map.Entry entry : this.tankStates.entrySet()) {
                ((PlayerItemTankState)entry.getValue()).update(this.client);
            }
            if (this.client) {
                Sets.SetView new_visible = Sets.difference((Set)this.a_visible, (Set)this.b_visible);
                Sets.SetView old_visible = Sets.difference((Set)this.b_visible, (Set)this.a_visible);
                if (!new_visible.isEmpty() || !old_visible.isEmpty()) {
                    PacketCustom packet = new PacketCustom((Object)"ES", 1);
                    packet.writeShort(new_visible.size());
                    for (String s : new_visible) {
                        packet.writeShort(TankSynchroniser.splitKeyF(s));
                        packet.writeString(TankSynchroniser.splitKeyS(s));
                    }
                    packet.writeShort(old_visible.size());
                    for (String s : old_visible) {
                        packet.writeShort(TankSynchroniser.splitKeyF(s));
                        packet.writeString(TankSynchroniser.splitKeyS(s));
                    }
                    packet.sendToServer();
                }
                HashSet temp = this.b_visible;
                temp.clear();
                this.b_visible = this.a_visible;
                this.a_visible = temp;
            }
        }

        public LiquidStack getLiquid(int freq, String owner) {
            String key = TankSynchroniser.key(freq, owner);
            this.a_visible.add(key);
            PlayerItemTankState state = (PlayerItemTankState)this.tankStates.get(key);
            return state == null ? new LiquidStack(0, 0) : state.c_liquid;
        }

        public void handleVisiblityPacket(PacketCustom packet) {
            int k = packet.readUnsignedShort();
            int i = 0;
            while (i < k) {
                this.track(packet.readUnsignedShort(), packet.readString(), true);
                ++i;
            }
            k = packet.readUnsignedShort();
            i = 0;
            while (i < k) {
                this.track(packet.readUnsignedShort(), packet.readString(), false);
                ++i;
            }
        }
    }

    public static class PlayerItemTankState
    extends TankState {
        private jc player;
        private boolean tracking;

        public PlayerItemTankState(jc player, EnderLiquidStorage storage) {
            this.player = player;
            this.reloadStorage(storage);
            this.tracking = true;
        }

        public PlayerItemTankState() {
        }

        @Override
        public void sendSyncPacket() {
            if (!this.tracking) {
                return;
            }
            PacketCustom packet = new PacketCustom((Object)"ES", 4);
            packet.writeShort(this.storage.freq);
            packet.writeString(this.storage.owner);
            packet.writeLiquidStack(this.s_liquid);
            packet.sendToPlayer((sq)this.player);
        }

        public void setTracking(boolean t) {
            this.tracking = t;
        }

        @Override
        public void update(boolean client) {
            if (this.tracking || client) {
                super.update(client);
            }
        }
    }

    public static abstract class TankState {
        public EnderLiquidStorage storage;
        public LiquidStack c_liquid = new LiquidStack(0, 0);
        public LiquidStack s_liquid = new LiquidStack(0, 0);
        public LiquidStack f_liquid = new LiquidStack(0, 0);

        public void reloadStorage(EnderLiquidStorage storage) {
            this.storage = storage;
        }

        public void update(boolean client) {
            LiquidStack a_liquid;
            LiquidStack b_liquid;
            if (client) {
                b_liquid = this.c_liquid.copy();
                if (this.s_liquid.isLiquidEqual(this.c_liquid)) {
                    this.c_liquid.amount = MathHelper.approachExpI((int)this.c_liquid.amount, (int)this.s_liquid.amount, (double)0.1);
                } else if (this.c_liquid.amount > 100) {
                    this.c_liquid.amount = MathHelper.retreatExpI((int)this.c_liquid.amount, (int)0, (int)this.f_liquid.amount, (double)0.1, (int)1000);
                } else {
                    this.c_liquid = LiquidUtils.copy((LiquidStack)this.s_liquid, (int)0);
                }
                a_liquid = this.c_liquid;
            } else {
                this.s_liquid = this.storage.getLiquid();
                b_liquid = this.s_liquid.copy();
                if (!this.s_liquid.isLiquidEqual(this.c_liquid)) {
                    this.sendSyncPacket();
                    this.c_liquid = this.s_liquid;
                } else if (Math.abs(this.c_liquid.amount - this.s_liquid.amount) > 250 || this.s_liquid.amount == 0 && this.c_liquid.amount > 0) {
                    this.sendSyncPacket();
                    this.c_liquid = this.s_liquid;
                }
                a_liquid = this.s_liquid;
            }
            if (b_liquid.amount == 0 != (a_liquid.amount == 0) || !b_liquid.isLiquidEqual(a_liquid)) {
                this.onLiquidChanged();
            }
        }

        public void onLiquidChanged() {
        }

        public abstract void sendSyncPacket();

        public void sync(LiquidStack liquid) {
            this.s_liquid = liquid;
            if (!this.s_liquid.isLiquidEqual(this.c_liquid)) {
                this.f_liquid = this.c_liquid.copy();
            }
        }
    }
}

