/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.liquid;

import codechicken.core.liquid.ExtendedLiquidTank;
import codechicken.core.liquid.LiquidUtils;
import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class EnderLiquidStorage
extends AbstractEnderStorage
implements ITankContainer {
    private Tank tank = new Tank(16 * LiquidUtils.B);

    public EnderLiquidStorage(EnderStorageManager manager, String owner, int freq) {
        super(manager, owner, freq);
    }

    @Override
    public void loadFromTag(bs tag) {
        this.tank.fromTag(tag.l("tank"));
    }

    @Override
    public String type() {
        return "liquid";
    }

    @Override
    public bs saveToTag() {
        bs compound = new bs();
        compound.a("tank", (cf)this.tank.toTag());
        return compound;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.tank;
    }

    public LiquidStack getLiquid() {
        return this.tank.getLiquid();
    }

    private class Tank
    extends ExtendedLiquidTank {
        public Tank(int capacity) {
            super(capacity);
        }

        public void onLiquidChanged() {
            EnderLiquidStorage.this.setDirty();
        }
    }
}

