/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.liquids;

import abo.ABO;
import abo.actions.ABOEnergyPulser;
import abo.actions.ActionSwitchOnPipe;
import abo.actions.ActionToggleOffPipe;
import abo.actions.ActionToggleOnPipe;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLiquidsWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeLiquidsValve
extends PipeLiquidsWood {
    private final ABOEnergyPulser pulser;
    private boolean powered;
    private boolean switched;
    private boolean toggled;
    private final int closedTexture = 18;
    private final int closedTextureSide = 19;
    private final int openTexture = 20;
    private final int openTextureSide = 21;

    public PipeLiquidsValve(int itemID) {
        super(itemID);
        ((PipeTransportLiquids)this.transport).flowRate = (short)160;
        ((PipeTransportLiquids)this.transport).travelDelay = (short)2;
        this.pulser = new ABOEnergyPulser((IPowerReceptor)this);
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return ABO.instance.pipeIconProvider;
    }

    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.isPowered() ? 20 : 18;
        }
        int metadata = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        if (metadata == direction.ordinal()) {
            return this.isPowered() ? 21 : 19;
        }
        return this.isPowered() ? 20 : 18;
    }

    public boolean isPowered() {
        return this.powered || this.switched || this.toggled;
    }

    public void updateRedstoneCurrent() {
        boolean lastPowered = this.powered;
        LinkedList<TileGenericPipe> neighbours = new LinkedList<TileGenericPipe>();
        neighbours.add(this.container);
        this.powered = false;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            Position pos = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, o);
            pos.moveForwards(1.0);
            TileEntity tile = this.container.getTile(o);
            if (!(tile instanceof TileGenericPipe)) continue;
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (!BlockGenericPipe.isValid((Pipe)pipe.pipe)) continue;
            neighbours.add(pipe);
            if (!pipe.pipe.broadcastRedstone) continue;
            this.powered = true;
        }
        if (!this.powered) {
            this.powered = this.worldObj.func_72864_z(this.xCoord, this.yCoord, this.zCoord);
        }
        if (lastPowered != this.powered) {
            for (TileGenericPipe pipe : neighbours) {
                pipe.scheduleNeighborChange();
                pipe.func_70316_g();
            }
        }
    }

    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.updateRedstoneCurrent();
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("powered", this.powered);
        nbttagcompound.func_74757_a("switched", this.switched);
        nbttagcompound.func_74757_a("toggled", this.toggled);
        NBTTagCompound nbttagcompoundC = new NBTTagCompound();
        this.pulser.writeToNBT(nbttagcompoundC);
        nbttagcompound.func_74782_a("Pulser", (NBTBase)nbttagcompoundC);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.func_74767_n("powered");
        this.switched = nbttagcompound.func_74767_n("switched");
        this.toggled = nbttagcompound.func_74767_n("toggled");
        NBTTagCompound nbttagcompoundP = nbttagcompound.func_74775_l("Pulser");
        this.pulser.readFromNBT(nbttagcompoundP);
    }

    public void updateEntity() {
        this.updateRedstoneCurrent();
        if (this.isPowered()) {
            this.pulser.enablePulse();
        } else {
            this.pulser.disablePulse();
            this.liquidToExtract = 0;
        }
        this.pulser.update();
        super.updateEntity();
    }

    public LinkedList getActions() {
        LinkedList actions = super.getActions();
        actions.add(ABO.actionSwitchOnPipe);
        actions.add(ABO.actionToggleOnPipe);
        actions.add(ABO.actionToggleOffPipe);
        return actions;
    }

    protected void actionsActivated(HashMap actions) {
        boolean lastSwitched = this.switched;
        boolean lastToggled = this.toggled;
        super.actionsActivated(actions);
        this.switched = false;
        for (Integer i : actions.keySet()) {
            if (!((Boolean)actions.get(i)).booleanValue()) continue;
            if (ActionManager.actions[i] instanceof ActionSwitchOnPipe) {
                this.switched = true;
                continue;
            }
            if (ActionManager.actions[i] instanceof ActionToggleOnPipe) {
                this.toggled = true;
                continue;
            }
            if (!(ActionManager.actions[i] instanceof ActionToggleOffPipe)) continue;
            this.toggled = false;
        }
        if (lastSwitched != this.switched || lastToggled != this.toggled) {
            if (lastSwitched != this.switched && !this.switched) {
                this.toggled = false;
            }
            this.container.scheduleRenderUpdate();
            this.updateNeighbors(true);
        }
    }
}

