/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.items;

import abo.pipes.ABOPipe;
import abo.pipes.items.PipeLogicStripes;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtil;
import buildcraft.core.utils.Utils;
import buildcraft.transport.EntityData;
import buildcraft.transport.IItemTravelingHook;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsStripes
extends ABOPipe
implements IItemTravelingHook,
IPowerReceptor {
    private static final int powerToBreakABlock = 50;
    private IPowerProvider powerProvider;

    public PipeItemsStripes(int itemID) {
        super((PipeTransport)new PipeTransportItems(), new PipeLogicStripes(), itemID);
        ((PipeTransportItems)this.transport).travelHook = this;
        this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
        this.powerProvider.configure(25, 0, 25, 50, 500);
    }

    public int getIconIndex(ForgeDirection direction) {
        return 7;
    }

    public void doWork() {
        ForgeDirection o;
        if (this.powerProvider.useEnergy(50.0f, 50.0f, true) == 50.0f && (o = this.getOpenOrientation()) != ForgeDirection.UNKNOWN) {
            Position p = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, o);
            p.moveForwards(1.0);
            List stacks = BlockUtil.getItemStackFromBlock((World)this.worldObj, (int)((int)p.x), (int)((int)p.y), (int)((int)p.z));
            if (stacks != null) {
                for (ItemStack s : stacks) {
                    if (s == null) continue;
                    EntityPassiveItem newItem = new EntityPassiveItem(this.worldObj, (double)this.xCoord + 0.5, (double)((float)this.yCoord + Utils.getPipeFloorOf((ItemStack)s)), (double)this.zCoord + 0.5, s);
                    this.container.entityEntering((IPipedItem)newItem, o.getOpposite());
                }
            }
            this.worldObj.func_94575_c((int)p.x, (int)p.y, (int)p.z, 0);
        }
    }

    public void drop(PipeTransportItems pipe, EntityData data) {
        Position p = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, data.output);
        p.moveForwards(1.0);
        if (this.worldObj.func_72798_a((int)p.x, (int)p.y, (int)p.z) == 0) {
            data.item.getItemStack().func_77973_b().func_77648_a(data.item.getItemStack(), CoreProxy.proxy.getBuildCraftPlayer(this.worldObj), this.worldObj, (int)p.x, (int)p.y - 1, (int)p.z, 1, 0.0f, 0.0f, 0.0f);
        } else {
            data.item.getItemStack().func_77973_b().func_77648_a(data.item.getItemStack(), CoreProxy.proxy.getBuildCraftPlayer(this.worldObj), this.worldObj, (int)p.x, (int)p.y, (int)p.z, 1, 0.0f, 0.0f, 0.0f);
        }
    }

    public void centerReached(PipeTransportItems pipe, EntityData data) {
    }

    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    public int powerRequest(ForgeDirection from) {
        return this.getPowerProvider().getMaxEnergyReceived();
    }

    public void endReached(PipeTransportItems pipe, EntityData data, TileEntity tile) {
    }
}

