/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.items;

import abo.ABO;
import abo.PipeIconProvider;
import abo.actions.ActionSwitchOnPipe;
import abo.actions.ActionToggleOffPipe;
import abo.actions.ActionToggleOnPipe;
import abo.pipes.ABOPipe;
import abo.pipes.items.PipeItemsCompactorInventory;
import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicStone;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsCompactor
extends ABOPipe
implements IPipeTransportItemsHook,
IActionReceptor {
    private final int onTexture = PipeIconProvider.PipeItemsCompactorOn;
    private final int offTexture = PipeIconProvider.PipeItemsCompactorOff;
    private boolean powered = false;
    private boolean toggled = false;
    private boolean switched = false;
    private final TreeMap receivedStacks = new TreeMap();
    private final SafeTimeTracker timeTracker = new SafeTimeTracker();

    public PipeItemsCompactor(int itemID) {
        super((PipeTransport)new PipeTransportItems(), (PipeLogic)new PipeLogicStone(), itemID);
    }

    public void addItemToItemStack(ForgeDirection orientation, ItemStack stack) {
        if (!this.receivedStacks.containsKey(orientation)) {
            this.receivedStacks.put(orientation, new PipeItemsCompactorInventory());
        }
        ((PipeItemsCompactorInventory)this.receivedStacks.get(orientation)).addItemStack(this.worldObj, stack);
    }

    public void dropContents() {
        this.powered = false;
        this.toggled = false;
        this.switched = false;
        for (Map.Entry receivedStack : this.receivedStacks.entrySet()) {
            ((PipeItemsCompactorInventory)receivedStack.getValue()).dropContents(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
        this.receivedStacks.clear();
        super.dropContents();
    }

    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
        if (this.isPowered() && item.getItemStack().func_77985_e()) {
            this.addItemToItemStack(orientation, item.getItemStack());
            ((PipeTransportItems)this.transport).scheduleRemoval(item);
        } else {
            this.readjustSpeed(item);
        }
    }

    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        return possibleOrientations;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.func_74767_n("powered");
        this.switched = nbttagcompound.func_74767_n("switched");
        this.toggled = nbttagcompound.func_74767_n("toggled");
        NBTTagList nbtItems = nbttagcompound.func_74761_m("items");
        for (int j = 0; j < nbtItems.func_74745_c(); ++j) {
            try {
                NBTTagCompound nbtTreeMap = (NBTTagCompound)nbtItems.func_74743_b(j);
                ForgeDirection orientation = ForgeDirection.values()[nbtTreeMap.func_74762_e("orientation")];
                if (!this.receivedStacks.containsKey(orientation)) {
                    this.receivedStacks.put(orientation, new PipeItemsCompactorInventory());
                }
                NBTTagCompound nbtItemStacks = (NBTTagCompound)nbtTreeMap.func_74781_a("itemStacks");
                ((PipeItemsCompactorInventory)this.receivedStacks.get(orientation)).readFromNBT(this.worldObj, nbtItemStacks);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("powered", this.powered);
        nbttagcompound.func_74757_a("switched", this.switched);
        nbttagcompound.func_74757_a("toggled", this.toggled);
        NBTTagList nbtItems = new NBTTagList();
        for (Map.Entry receivedStack : this.receivedStacks.entrySet()) {
            NBTTagCompound nbtTreeMap = new NBTTagCompound();
            NBTTagCompound nbtItemStacks = new NBTTagCompound();
            nbtTreeMap.func_74768_a("orientation", ((ForgeDirection)receivedStack.getKey()).ordinal());
            ((PipeItemsCompactorInventory)receivedStack.getValue()).writeToNBT(nbtItemStacks);
            nbtTreeMap.func_74782_a("itemStacks", (NBTBase)nbtItemStacks);
            nbtItems.func_74742_a((NBTBase)nbtTreeMap);
        }
        nbttagcompound.func_74782_a("items", (NBTBase)nbtItems);
    }

    public boolean isPowered() {
        return this.powered || this.switched || this.toggled;
    }

    public void updateRedstoneCurrent() {
        boolean lastPowered = this.powered;
        LinkedList<TileGenericPipe> neighbours = new LinkedList<TileGenericPipe>();
        neighbours.add(this.container);
        this.powered = false;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            Position pos = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, o);
            pos.moveForwards(1.0);
            TileEntity tile = this.container.getTile(o);
            if (!(tile instanceof TileGenericPipe)) continue;
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (!BlockGenericPipe.isValid((Pipe)pipe.pipe)) continue;
            neighbours.add(pipe);
            if (!pipe.pipe.broadcastRedstone) continue;
            this.powered = true;
        }
        if (!this.powered) {
            this.powered = this.worldObj.func_72864_z(this.xCoord, this.yCoord, this.zCoord);
        }
        if (lastPowered != this.powered) {
            for (TileGenericPipe pipe : neighbours) {
                pipe.scheduleNeighborChange();
                pipe.func_70316_g();
            }
        }
    }

    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.updateRedstoneCurrent();
    }

    public LinkedList getActions() {
        LinkedList actions = super.getActions();
        actions.add(ABO.actionSwitchOnPipe);
        actions.add(ABO.actionToggleOnPipe);
        actions.add(ABO.actionToggleOffPipe);
        return actions;
    }

    protected void actionsActivated(HashMap actions) {
        boolean lastSwitched = this.switched;
        boolean lastToggled = this.toggled;
        super.actionsActivated(actions);
        this.switched = false;
        for (Integer i : actions.keySet()) {
            if (!((Boolean)actions.get(i)).booleanValue()) continue;
            if (ActionManager.actions[i] instanceof ActionSwitchOnPipe) {
                this.switched = true;
                continue;
            }
            if (ActionManager.actions[i] instanceof ActionToggleOnPipe) {
                this.toggled = true;
                continue;
            }
            if (!(ActionManager.actions[i] instanceof ActionToggleOffPipe)) continue;
            this.toggled = false;
        }
        if (!(lastSwitched == this.switched && lastToggled == this.toggled || lastSwitched == this.switched || this.switched)) {
            this.toggled = false;
        }
    }

    public void actionActivated(IAction action) {
        boolean lastSwitched = this.switched;
        boolean lastToggled = this.toggled;
        this.switched = false;
        if (action instanceof ActionToggleOnPipe) {
            this.toggled = true;
        } else if (action instanceof ActionToggleOffPipe) {
            this.toggled = false;
        }
        if (!(lastSwitched == this.switched && lastToggled == this.toggled || lastSwitched == this.switched || this.switched)) {
            this.toggled = false;
        }
    }

    public void updateEntity() {
        super.updateEntity();
        this.updateRedstoneCurrent();
        if (this.isPowered() && this.timeTracker.markTimeIfDelay(this.worldObj, 25L)) {
            for (Map.Entry receivedStack : this.receivedStacks.entrySet()) {
                ItemStack stack = ((PipeItemsCompactorInventory)receivedStack.getValue()).findItemStackToRemove(this.worldObj, 16, 100);
                if (stack == null || Utils.addToRandomPipeEntry((TileEntity)this.container, (ForgeDirection)((ForgeDirection)receivedStack.getKey()), (ItemStack)stack)) continue;
                Position destPos = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (ForgeDirection)receivedStack.getKey());
                destPos.moveForwards(0.3);
                Utils.dropItems((World)this.worldObj, (ItemStack)stack, (int)((int)destPos.x), (int)((int)destPos.y), (int)((int)destPos.z));
            }
        }
    }

    public void readjustSpeed(IPipedItem item) {
        item.setSpeed(Math.min(Math.max(Utils.pipeNormalSpeed, item.getSpeed()) * 2.0f, Utils.pipeNormalSpeed * 30.0f));
    }

    public int getIconIndex(ForgeDirection direction) {
        if (this.worldObj != null) {
            return this.isPowered() ? this.onTexture : this.offTexture;
        }
        return this.offTexture;
    }
}

