/*
 * Decompiled with CFR 0.152.
 */
package abo.network;

import abo.network.ABOPacket;
import abo.network.ILiquidSlotChange;
import buildcraft.transport.TileGenericPipe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.liquids.LiquidStack;

public class PacketLiquidSlotChange
extends ABOPacket {
    private int slot;
    private LiquidStack stack;

    public PacketLiquidSlotChange(int xCoord, int yCoord, int zCoord, int slot, LiquidStack stack) {
        super(2, xCoord, yCoord, zCoord);
        this.slot = slot;
        this.stack = stack;
    }

    public PacketLiquidSlotChange(DataInputStream data) throws IOException {
        this.readData(data);
    }

    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeInt(this.slot);
        if (this.stack == null) {
            data.writeShort(0);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            this.stack.writeToNBT(nbt);
            byte[] compressed = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
            data.writeShort(compressed.length);
            data.write(compressed);
        }
    }

    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.slot = data.readInt();
        short length = data.readShort();
        if (length == 0) {
            this.stack = null;
        } else {
            byte[] compressed = new byte[length];
            data.readFully(compressed);
            NBTTagCompound nbt = CompressedStreamTools.func_74792_a((byte[])compressed);
            this.stack = LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)nbt);
        }
    }

    public void update(EntityPlayer player) {
        TileGenericPipe pipe = this.getPipe(player.field_70170_p, this.posX, this.posY, this.posZ);
        if (pipe == null || pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof ILiquidSlotChange)) {
            return;
        }
        ((ILiquidSlotChange)pipe.pipe.logic).update(this.slot, this.stack);
    }
}

