/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.forestry.bees;

import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.fml.common.Loader;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.forestry.AddonForestry;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.bdew.neiaddons.forestry.bees.BeeBreedingHandler;
import net.bdew.neiaddons.forestry.bees.BeeProduceHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BeeHelper {
    private static BeeBreedingHandler breedingRecipeHandler;
    private static BeeProduceHandler productsRecipeHandler;
    public static Collection allSpecies;
    public static Map productsCache;
    public static IBeeRoot root;

    private static void addProductToCache(int id, IAlleleBeeSpecies species) {
        if (!productsCache.containsKey(id)) {
            productsCache.put(id, new ArrayList());
        }
        ((Collection)productsCache.get(id)).add(species);
    }

    private static void addHandlers() {
        if (AddonForestry.showBeeMutations) {
            breedingRecipeHandler = new BeeBreedingHandler();
            API.registerRecipeHandler((ICraftingHandler)breedingRecipeHandler);
            API.registerUsageHandler((IUsageHandler)breedingRecipeHandler);
            AddonForestry.instance.registerWithNEIPlugins(breedingRecipeHandler.getRecipeName(), breedingRecipeHandler.getRecipeIdent());
        }
        if (AddonForestry.showBeeProducts) {
            productsRecipeHandler = new BeeProduceHandler();
            API.registerRecipeHandler((ICraftingHandler)productsRecipeHandler);
            API.registerUsageHandler((IUsageHandler)productsRecipeHandler);
            AddonForestry.instance.registerWithNEIPlugins(productsRecipeHandler.getRecipeName(), productsRecipeHandler.getRecipeIdent());
        }
    }

    public static void setup() {
        root = (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        allSpecies = GeneticsUtils.getAllBeeSpecies(AddonForestry.loadBlacklisted);
        BeeHelper.addHandlers();
        HashMap seencombs = new HashMap();
        List modCombs = BeeHelper.getMobCombs();
        for (Item combItem : modCombs) {
            seencombs.put(combItem.field_77779_bT, new HashSet());
        }
        productsCache = new HashMap();
        for (IAlleleBeeSpecies species : allSpecies) {
            if (AddonForestry.addBees) {
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumBeeType.QUEEN.ordinal()));
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumBeeType.DRONE.ordinal()));
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumBeeType.PRINCESS.ordinal()));
            }
            for (ItemStack prod : GeneticsUtils.getProduceFromSpecies((IAlleleSpecies)species).keySet()) {
                BeeHelper.addProductToCache(prod.field_77993_c, species);
                if (!AddonForestry.addCombs || !seencombs.containsKey(prod.field_77993_c)) continue;
                ((HashSet)seencombs.get(prod.field_77993_c)).add(prod.func_77960_j());
            }
            for (ItemStack prod : GeneticsUtils.getSpecialtyFromSpecies((IAlleleSpecies)species).keySet()) {
                BeeHelper.addProductToCache(prod.field_77993_c, species);
                if (!AddonForestry.addCombs || !seencombs.containsKey(prod.field_77993_c)) continue;
                ((HashSet)seencombs.get(prod.field_77993_c)).add(prod.func_77960_j());
            }
        }
        if (AddonForestry.addCombs) {
            for (Item combItem : modCombs) {
                HashSet subitems = (HashSet)seencombs.get(combItem.field_77779_bT);
                ArrayList combs = new ArrayList();
                combItem.func_77633_a(combItem.field_77779_bT, null, combs);
                for (ItemStack item : combs) {
                    subitems.add(item.func_77960_j());
                }
                AddonForestry.instance.logInfo("Registering variants for %s: %s", combItem.getClass().getName(), subitems.toString());
                API.setItemDamageVariants((int)combItem.field_77779_bT, (Collection)subitems);
            }
        }
        if (!Loader.isModLoaded((String)"NEIPlugins")) {
            MultiItemRange queenRange = new MultiItemRange();
            queenRange.add(ItemInterface.getItem((String)"beeQueenGE"));
            API.addSetRange((String)"Forestry.Bees.Queens", (MultiItemRange)queenRange);
            MultiItemRange princessRange = new MultiItemRange();
            princessRange.add(ItemInterface.getItem((String)"beePrincessGE"));
            API.addSetRange((String)"Forestry.Bees.Princesses", (MultiItemRange)princessRange);
            MultiItemRange droneRange = new MultiItemRange();
            droneRange.add(ItemInterface.getItem((String)"beeDroneGE"));
            API.addSetRange((String)"Forestry.Bees.Drones", (MultiItemRange)droneRange);
            MultiItemRange combRange = new MultiItemRange();
            for (Item i : modCombs) {
                combRange.add(i.field_77779_bT);
            }
            API.addSetRange((String)"Forestry.Bees.Combs", (MultiItemRange)combRange);
        }
    }

    private static List getMobCombs() {
        ArrayList<Item> res = new ArrayList<Item>();
        res.add(ItemInterface.getItem((String)"beeComb").func_77973_b());
        if (Loader.isModLoaded((String)"ExtraBees")) {
            try {
                Class<?> ebItems = Class.forName("binnie.extrabees.ExtraBees");
                Object ebComb = ebItems.getField("comb").get(null);
                if (ebComb instanceof Item) {
                    AddonForestry.instance.logInfo("Loaded Extra Bees comb item: %s (%d)", ebComb.toString(), ((Item)ebComb).field_77779_bT);
                    res.add((Item)ebComb);
                } else {
                    AddonForestry.instance.logWarning("Extra Bees comb is not Item subclass!", new Object[0]);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (Loader.isModLoaded((String)"MagicBees")) {
            try {
                Class<?> mbConfig = Class.forName("magicbees.main.Config");
                Object mbComb = mbConfig.getField("combs").get(null);
                AddonForestry.instance.logInfo("Loaded TB comb item: %s", mbComb.toString());
                if (mbComb instanceof Item) {
                    AddonForestry.instance.logInfo("Loaded Magic Bees comb item: %s (%d)", mbComb.toString(), ((Item)mbComb).field_77779_bT);
                    res.add((Item)mbComb);
                } else {
                    AddonForestry.instance.logWarning("Magic Bees comb is not Item subclass!", new Object[0]);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return res;
    }
}

