/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.extrabees;

import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import java.util.HashSet;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.extrabees.AddonExtraBees;
import net.bdew.neiaddons.extrabees.AlleleBeeChromosomePair;
import net.bdew.neiaddons.extrabees.IsolatorRecipeHandler;
import net.bdew.neiaddons.extrabees.SerumUtils;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.minecraft.item.ItemStack;

public class AddonExtraBeesClient {
    public static IBeeRoot beeRoot;

    public static void registerSerums() {
        HashSet<AlleleBeeChromosomePair> res = new HashSet<AlleleBeeChromosomePair>();
        beeRoot = (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        for (IAlleleBeeSpecies species : AddonExtraBees.allBeeSpecies) {
            IAllele[] template = beeRoot.getTemplate(species.getUID());
            if (template == null) {
                AddonExtraBees.instance.logWarning("Template for %s is null, wtf?", species.getUID());
                continue;
            }
            for (int i = 0; i < template.length; ++i) {
                if (template[i] == null) continue;
                if (!AddonExtraBees.loadBlacklisted && AlleleManager.alleleRegistry.isBlacklisted(template[i].getUID())) {
                    if (!AddonExtraBees.dumpSerums) continue;
                    AddonExtraBees.instance.logInfo("Skipping blacklisted allele: %s", template[i].getUID());
                    continue;
                }
                if (!SerumUtils.shouldMakeSerum(template[i].getUID(), i)) continue;
                res.add(new AlleleBeeChromosomePair(template[i], i));
            }
        }
        if (AddonExtraBees.dumpSerums) {
            AddonExtraBees.instance.logInfo("==== Serum dump ====", new Object[0]);
            for (EnumBeeChromosome chromosome : EnumBeeChromosome.values()) {
                AddonExtraBees.instance.logInfo("%s:", chromosome.toString());
                for (AlleleBeeChromosomePair pair : res) {
                    if (pair.chromosome != chromosome.ordinal()) continue;
                    try {
                        AddonExtraBees.instance.logInfo(" * %s -> %s", pair.allele, SerumUtils.getSerum(pair).func_82833_r());
                    }
                    catch (Throwable e) {
                        AddonExtraBees.instance.logInfo(" * %s -> BORKED! %s", pair.allele, e.toString());
                        e.printStackTrace();
                    }
                }
                AddonExtraBees.instance.logInfo("===================================", new Object[0]);
            }
        }
        for (AlleleBeeChromosomePair pair : res) {
            API.addNBTItem((ItemStack)SerumUtils.getSerum(pair));
        }
    }

    private static void addSubsets() {
        Class<?> ebConfig;
        Class<?> ebMain;
        try {
            ebMain = Class.forName("binnie.extrabees.ExtraBees");
            ebConfig = Class.forName("binnie.extrabees.config.ConfigurationMain");
        }
        catch (Throwable e) {
            AddonExtraBees.instance.logWarning("Failed to get Extra Bees items and blocks", new Object[0]);
            e.printStackTrace();
            return;
        }
        Utils.addSubsetForItem(ebMain, "template", "Extra Bees.Templates");
        Utils.addSubsetForItem(ebMain, "serum", "Extra Bees.Serums");
        Utils.addSubsetForItem(ebMain, "liquidContainer", "Extra Bees.Containers");
        Utils.addSubsetForItem(ebMain, "apiaristMachine", "Extra Bees.Machines.Apiarist");
        Utils.addSubsetForItem(ebMain, "geneticMachine", "Extra Bees.Machines.Genetic");
        Utils.addSubsetForItem(ebMain, "advGeneticMachine", "Extra Bees.Machines.Advanced");
        Utils.addSubsetForItem(ebMain, "hive", "Extra Bees.Hives");
        Utils.addSubsetForItems(ebMain, new String[]{"templateBlank", "dictionary", "serumEmpty", "itemMisc"}, "Extra Bees.Misc");
        Utils.addSubsetForItems(ebConfig, new String[]{"hiveFrameID", "hiveFrame2ID", "hiveFrame3ID", "hiveFrame4ID", "hiveFrame5ID"}, "Extra Bees.Frames", 256);
        Utils.addSubsetForItem(ebConfig, "alvearyID", "Extra Bees.Machines.Alveary");
    }

    public static void load() {
        try {
            SerumUtils.setup();
        }
        catch (Throwable e) {
            AddonExtraBees.instance.logWarning("Failed to get serum item:", new Object[0]);
            e.printStackTrace();
            return;
        }
        AddonExtraBees.allBeeSpecies = GeneticsUtils.getAllBeeSpecies(AddonExtraBees.loadBlacklisted);
        AddonExtraBeesClient.registerSerums();
        API.registerRecipeHandler((ICraftingHandler)new IsolatorRecipeHandler());
        AddonExtraBeesClient.addSubsets();
        FMLInterModComms.sendRuntimeMessage((Object)AddonExtraBees.instance, (String)"NEIPlugins", (String)"register-crafting-handler", (String)"Exta Bees@Isolator@isolator");
    }
}

