/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.tick;

import andrew.powersuits.client.WaterMeter;
import andrew.powersuits.common.AddonConfig;
import andrew.powersuits.common.AddonUtils;
import andrew.powersuits.common.AddonWaterUtils;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.ArrayList;
import java.util.EnumSet;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.item.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.item.ItemPowerArmorHelmet;
import net.machinemuse.powersuits.item.ItemPowerFist;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MuseStringUtils;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RenderTickHandler
implements ITickHandler {
    static double yBaseIcon;
    static int yBaseString;
    double yOffsetIcon = 16.0;
    int yOffsetString = 18;
    String ampm = "";
    ArrayList modules;
    protected static WaterMeter water;
    ItemStack food = new ItemStack(Item.field_77734_bj);
    ItemStack torch = new ItemStack(Block.field_72069_aq);
    ItemStack clock = new ItemStack(Item.field_77752_aS);
    ItemStack compass = new ItemStack(Item.field_77750_aQ);

    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        this.modules = new ArrayList();
        this.findInstalledModules(player);
        if (player != null && MuseItemUtils.modularItemsEquipped((EntityPlayer)player).size() > 0 && Minecraft.func_71410_x().field_71462_r == null) {
            for (int i = 0; i < this.modules.size(); ++i) {
                if (((String)this.modules.get(i)).equals("Auto-Feeder")) {
                    int foodLevel = (int)AddonUtils.getFoodLevel(player.func_82169_q(3));
                    String num = MuseStringUtils.formatNumberShort((double)foodLevel);
                    if (i == 0) {
                        MuseRenderer.drawString((String)num, (double)17.0, (double)yBaseString);
                        MuseRenderer.drawItemAt((double)-1.0, (double)yBaseIcon, (ItemStack)this.food);
                        continue;
                    }
                    MuseRenderer.drawString((String)num, (double)17.0, (double)(yBaseString + this.yOffsetString * i));
                    MuseRenderer.drawItemAt((double)-1.0, (double)(yBaseIcon + this.yOffsetIcon * (double)i), (ItemStack)this.food);
                    continue;
                }
                if (((String)this.modules.get(i)).equals("Torch Placer")) {
                    int torchLevel = AddonUtils.getTorchLevel(player.func_71045_bC());
                    int maxTorchLevel = (int)ModuleManager.computeModularProperty((ItemStack)player.func_71045_bC(), (String)"Maximum Storage Amount");
                    String num = MuseStringUtils.formatNumberShort((double)torchLevel) + "/" + MuseStringUtils.formatNumberShort((double)maxTorchLevel);
                    if (i == 0) {
                        MuseRenderer.drawString((String)num, (double)17.0, (double)yBaseString);
                        MuseRenderer.drawItemAt((double)-1.0, (double)yBaseIcon, (ItemStack)this.torch);
                        continue;
                    }
                    MuseRenderer.drawString((String)num, (double)17.0, (double)(yBaseString + this.yOffsetString * i));
                    MuseRenderer.drawItemAt((double)-1.0, (double)(yBaseIcon + this.yOffsetIcon * (double)i), (ItemStack)this.torch);
                    continue;
                }
                if (((String)this.modules.get(i)).equals("Clock")) {
                    long time = player.field_70170_p.field_73011_w.getWorldTime();
                    int hour = (int)(time % 24000L / 1000L);
                    if (AddonConfig.use24hClock) {
                        hour = hour < 19 ? (hour += 6) : (hour -= 18);
                        this.ampm = "h";
                    } else if (hour < 6) {
                        hour += 6;
                        this.ampm = " AM";
                    } else if (hour == 6) {
                        hour = 12;
                        this.ampm = " PM";
                    } else if (hour > 6 && hour < 18) {
                        hour -= 6;
                        this.ampm = " PM";
                    } else if (hour == 18) {
                        hour = 12;
                        this.ampm = " AM";
                    } else {
                        hour -= 18;
                        this.ampm = " AM";
                    }
                    if (i == 0) {
                        MuseRenderer.drawString((String)(hour + this.ampm), (double)17.0, (double)yBaseString);
                        MuseRenderer.drawItemAt((double)-1.0, (double)yBaseIcon, (ItemStack)this.clock);
                        continue;
                    }
                    MuseRenderer.drawString((String)(hour + this.ampm), (double)17.0, (double)(yBaseString + this.yOffsetString * i));
                    MuseRenderer.drawItemAt((double)-1.0, (double)(yBaseIcon + this.yOffsetIcon * (double)i), (ItemStack)this.clock);
                    continue;
                }
                if (((String)this.modules.get(i)).equals("Compass")) {
                    if (i == 0) {
                        MuseRenderer.drawItemAt((double)-1.0, (double)yBaseIcon, (ItemStack)this.compass);
                        continue;
                    }
                    MuseRenderer.drawItemAt((double)-1.0, (double)(yBaseIcon + this.yOffsetIcon * (double)i), (ItemStack)this.compass);
                    continue;
                }
                if (!((String)this.modules.get(i)).equals("Water Tank")) continue;
                Minecraft mc = Minecraft.func_71410_x();
                ScaledResolution screen = new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
                this.drawMeters((EntityPlayer)player, screen);
            }
        }
    }

    public void findInstalledModules(EntityClientPlayerMP player) {
        if (player != null) {
            ItemStack chest;
            ItemStack helmet;
            ItemStack tool = player.func_71045_bC();
            if (tool != null && tool.func_77973_b() instanceof ItemPowerFist && MuseItemUtils.itemHasActiveModule((ItemStack)tool, (String)"Torch Placer")) {
                this.modules.add("Torch Placer");
            }
            if ((helmet = player.func_82169_q(3)) != null && helmet.func_77973_b() instanceof ItemPowerArmorHelmet) {
                if (MuseItemUtils.itemHasActiveModule((ItemStack)helmet, (String)"Auto-Feeder")) {
                    this.modules.add("Auto-Feeder");
                }
                if (MuseItemUtils.itemHasActiveModule((ItemStack)helmet, (String)"Clock")) {
                    this.modules.add("Clock");
                }
                if (MuseItemUtils.itemHasActiveModule((ItemStack)helmet, (String)"Compass")) {
                    this.modules.add("Compass");
                }
            }
            if ((chest = player.func_82169_q(2)) != null && chest.func_77973_b() instanceof ItemPowerArmorChestplate && MuseItemUtils.itemHasActiveModule((ItemStack)chest, (String)"Water Tank")) {
                this.modules.add("Water Tank");
            }
        }
    }

    private void drawMeters(EntityPlayer player, ScaledResolution screen) {
        double currWater = AddonWaterUtils.getPlayerWater(player);
        double maxWater = AddonWaterUtils.getMaxWater(player);
        String currStr = MuseStringUtils.formatNumberShort((double)currWater);
        String maxStr = MuseStringUtils.formatNumberShort((double)maxWater);
        if (Config.useGraphicalMeters()) {
            if (water == null) {
                water = new WaterMeter();
            }
            double left = screen.func_78326_a() - 12;
            double top = (double)screen.func_78328_b() / 2.0 - 16.0 + 40.0;
            water.draw(left, top, currWater / maxWater);
            MuseRenderer.drawRightAlignedString((String)currStr, (double)(left - 2.0), (double)(top + 15.0));
        } else {
            MuseRenderer.drawString((String)(currStr + '/' + maxStr + " buckets"), (double)1.0, (double)19.0);
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.RENDER);
    }

    public String getLabel() {
        return "MPSA: Render Tick";
    }

    static {
        if (Config.useGraphicalMeters()) {
            yBaseIcon = -1.0;
            yBaseString = 4;
        } else {
            yBaseIcon = 26.0;
            yBaseString = 32;
        }
    }
}

