/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.network.muse;

import andrew.powersuits.common.AddonLogger;
import andrew.powersuits.network.AndrewPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.machinemuse.powersuits.common.Config;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet250CustomPayload;

public abstract class MusePacketOld {
    protected static final int READ_ERROR = -150;
    protected Player player;
    protected ByteArrayOutputStream bytes;
    protected Packet250CustomPayload packet;
    protected DataOutputStream dataout;
    protected DataInputStream datain;
    protected int id;

    protected MusePacketOld(Player player) {
        this.player = player;
        this.bytes = new ByteArrayOutputStream();
        this.dataout = new DataOutputStream(this.bytes);
        try {
            int id = AndrewPacketHandler.getTypeID(this);
            this.writeInt(id);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected MusePacketOld(DataInputStream data, Player player) {
        this.player = player;
        this.datain = data;
    }

    public Packet250CustomPayload getPacket250() {
        return new Packet250CustomPayload(Config.getNetworkChannelName(), this.bytes.toByteArray());
    }

    public abstract void handleClient(EntityClientPlayerMP var1);

    public abstract void handleServer(EntityPlayerMP var1);

    public int readInt() {
        try {
            int read = this.datain.readInt();
            return read;
        }
        catch (IOException e) {
            AddonLogger.logError("PROBLEM READING INT FROM PACKET D:");
            e.printStackTrace();
            return -150;
        }
    }

    public void writeInt(int i) {
        try {
            this.dataout.writeInt(i);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int[] readIntArray() {
        try {
            int length = this.datain.readInt();
            int[] read = new int[length];
            for (int k = 0; k < read.length; ++k) {
                read[k] = this.datain.readInt();
            }
            return read;
        }
        catch (IOException e) {
            AddonLogger.logError("PROBLEM READING INT FROM PACKET D:");
            e.printStackTrace();
            return null;
        }
    }

    public void writeIntArray(int[] data) {
        try {
            this.dataout.writeInt(data.length);
            for (int k = 0; k < data.length; ++k) {
                this.dataout.writeInt(data[k]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean readBoolean() {
        try {
            boolean read = this.datain.readBoolean();
            return read;
        }
        catch (IOException e) {
            AddonLogger.logError("PROBLEM READING DOUBLE FROM PACKET D:");
            e.printStackTrace();
            return false;
        }
    }

    public void writeBoolean(boolean val) {
        try {
            this.dataout.writeBoolean(val);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double readDouble() {
        try {
            double read = this.datain.readDouble();
            return read;
        }
        catch (IOException e) {
            AddonLogger.logError("PROBLEM READING DOUBLE FROM PACKET D:");
            e.printStackTrace();
            return -150.0;
        }
    }

    public void writeDouble(double i) {
        try {
            this.dataout.writeDouble(i);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ItemStack readItemStack() {
        ItemStack stack = null;
        try {
            short itemID = this.datain.readShort();
            if (itemID >= 0) {
                byte stackSize = this.datain.readByte();
                short damageAmount = this.datain.readShort();
                stack = new ItemStack((int)itemID, (int)stackSize, (int)damageAmount);
                stack.field_77990_d = this.readNBTTagCompound();
            }
        }
        catch (IOException e) {
            AddonLogger.logError("Problem reading itemstack D:");
            e.printStackTrace();
        }
        return stack;
    }

    public void writeItemStack(ItemStack stack) {
        try {
            if (stack == null) {
                this.dataout.writeShort(-1);
            } else {
                this.dataout.writeShort(stack.field_77993_c);
                this.dataout.writeByte(stack.field_77994_a);
                this.dataout.writeShort(stack.func_77960_j());
                NBTTagCompound nbt = null;
                if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
                    nbt = stack.field_77990_d;
                }
                this.writeNBTTagCompound(nbt);
            }
        }
        catch (IOException e) {
            AddonLogger.logError("Problem writing itemstack D:");
            e.printStackTrace();
        }
    }

    public NBTTagCompound readNBTTagCompound() throws IOException {
        short length = this.datain.readShort();
        if (length < 0) {
            return null;
        }
        byte[] fullData = new byte[length];
        this.datain.readFully(fullData);
        return CompressedStreamTools.func_74792_a((byte[])fullData);
    }

    protected void writeNBTTagCompound(NBTTagCompound nbt) throws IOException {
        if (nbt == null) {
            this.dataout.writeShort(-1);
        } else {
            byte[] compressednbt = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
            this.dataout.writeShort((short)compressednbt.length);
            this.dataout.write(compressednbt);
        }
    }

    public void writeString(String string) {
        try {
            this.dataout.writeShort(string.length());
            this.dataout.writeChars(string);
        }
        catch (IOException e) {
            AddonLogger.logError("String too big D:");
            e.printStackTrace();
        }
    }

    public String readString(int maxlength) {
        String read = null;
        try {
            int length = this.datain.readShort();
            if (length > maxlength) {
                throw new IOException("Received string length longer than maximum allowed (" + length + " > " + maxlength + ')');
            }
            if (length < 0) {
                throw new IOException("Received string length is less than zero! Weird string!");
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                builder.append(this.datain.readChar());
            }
            read = builder.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return read;
    }
}

