/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import andrew.powersuits.common.AddonUtils;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class WaterTankModule
extends PowerModuleBase
implements IPlayerTickModule {
    public static final String MODULE_WATER_TANK = "Water Tank";
    public static final String WATER_TANK_SIZE = "Tank Size";
    ItemStack bucketWater = new ItemStack(Item.field_77786_ax);

    public WaterTankModule(List validItems) {
        super(validItems);
        this.addBaseProperty(WATER_TANK_SIZE, 200.0);
        this.addBaseProperty("Weight", 1000.0);
        this.addTradeoffProperty(WATER_TANK_SIZE, WATER_TANK_SIZE, 800.0, " buckets");
        this.addTradeoffProperty(WATER_TANK_SIZE, "Weight", 4000.0, "g");
        this.addInstallCost(new ItemStack(Item.field_77786_ax));
        this.addInstallCost(new ItemStack(Block.field_71946_M, 8));
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.controlCircuit, (int)2));
    }

    public String getTextureFile() {
        return null;
    }

    public Icon getIcon(ItemStack item) {
        return this.bucketWater.func_77954_c();
    }

    public String getCategory() {
        return "Environment";
    }

    public String getName() {
        return MODULE_WATER_TANK;
    }

    public String getDescription() {
        return "Store water which can later be used to cool yourself in emergency situations.";
    }

    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (player.func_70090_H() && AddonUtils.getWaterLevel(item) < ModuleManager.computeModularProperty((ItemStack)item, (String)WATER_TANK_SIZE)) {
            AddonUtils.setWaterLevel(item, AddonUtils.getWaterLevel(item) + 1.0);
        }
        if (player.field_70170_p.func_72896_J() && player.field_70170_p.func_82737_E() % 5L == 0L && AddonUtils.getWaterLevel(item) < ModuleManager.computeModularProperty((ItemStack)item, (String)WATER_TANK_SIZE)) {
            AddonUtils.setWaterLevel(item, AddonUtils.getWaterLevel(item) + 1.0);
        }
        if (MuseHeatUtils.getPlayerHeat((EntityPlayer)player) >= MuseHeatUtils.getMaxHeat((EntityPlayer)player) - 1.0 && AddonUtils.getWaterLevel(item) > 0.0) {
            MuseHeatUtils.coolPlayer((EntityPlayer)player, (double)1.0);
            AddonUtils.setWaterLevel(item, AddonUtils.getWaterLevel(item) - 1.0);
        }
    }

    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }
}

