/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import andrew.powersuits.common.AddonUtils;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class TreetapModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_TREETAP = "Treetap";
    public static final String TREETAP_ENERGY_CONSUMPTION = "Energy Consumption";
    private static ItemStack rubber = ModCompatability.getIC2Item((String)"rubberWood");
    private static ItemStack resin = ModCompatability.getIC2Item((String)"resin");

    public TreetapModule(List validItems) {
        super(validItems);
        this.addBaseProperty(TREETAP_ENERGY_CONSUMPTION, 100.0);
        this.addInstallCost(ModCompatability.getIC2Item((String)"electricTreetap"));
    }

    public String getTextureFile() {
        return "treetap";
    }

    public String getCategory() {
        return "Tool";
    }

    public String getName() {
        return MODULE_TREETAP;
    }

    public String getDescription() {
        return "An IC2 treetap integrated in your power tool.";
    }

    public void onRightClick(EntityPlayer player, World world, ItemStack item) {
    }

    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        int blockID = world.func_72798_a(x, y, z);
        if (blockID == TreetapModule.rubber.field_77993_c) {
            TreetapModule.tryExtract(player, world, x, y, z, side, null);
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (double)ModuleManager.computeModularProperty((ItemStack)itemStack, (String)TREETAP_ENERGY_CONSUMPTION));
        }
    }

    public static boolean tryExtract(EntityPlayer player, World world, int x, int y, int z, int side, List stacks) {
        ItemStack tempResin;
        int metadata = world.func_72805_g(x, y, z);
        if (metadata < 2 || metadata % 6 != side) {
            return false;
        }
        if (metadata < 6 && AddonUtils.isServerSide()) {
            world.func_72921_c(x, y, z, metadata + 6, 7);
            if (stacks != null) {
                tempResin = resin.func_77946_l();
                tempResin.field_77994_a = world.field_73012_v.nextInt(3);
                stacks.add(tempResin);
            } else {
                TreetapModule.eject(world, x, y, z, side, world.field_73012_v.nextInt(3) + 1);
            }
            world.func_72836_a(x, y, z, TreetapModule.rubber.field_77993_c, Block.field_71973_m[TreetapModule.rubber.field_77993_c].func_71859_p_(world));
        }
        if (world.field_73012_v.nextInt(5) == 0 && AddonUtils.isServerSide()) {
            world.func_72921_c(x, y, z, 1, 7);
        }
        if (world.field_73012_v.nextInt(5) == 0) {
            if (AddonUtils.isServerSide()) {
                TreetapModule.eject(world, x, y, z, side, 1);
                if (stacks != null) {
                    tempResin = resin.func_77946_l();
                    tempResin.field_77994_a = world.field_73012_v.nextInt(3);
                    stacks.add(tempResin);
                } else {
                    TreetapModule.eject(world, x, y, z, side, 1);
                }
            }
            return true;
        }
        return false;
    }

    public static void eject(World world, int x, int y, int z, int side, int quantity) {
        double ejectX = (double)x + 0.5;
        double ejectY = (double)y + 0.5;
        double ejectZ = (double)z + 0.5;
        if (side == 2) {
            ejectZ -= 0.3;
        } else if (side == 5) {
            ejectX += 0.3;
        } else if (side == 3) {
            ejectZ += 0.3;
        } else if (side == 4) {
            ejectX -= 0.3;
        }
        for (int i = 0; i < quantity; ++i) {
            EntityItem item = new EntityItem(world, ejectX, ejectY, ejectZ, resin.func_77946_l());
            item.field_70293_c = 10;
            world.func_72838_d((Entity)item);
        }
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }
}

