/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import andrew.powersuits.common.AddonConfig;
import andrew.powersuits.common.AddonUtils;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class TorchPlacerModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule,
IRightClickModule {
    public static final String MODULE_TORCH_PLACER = "Torch Placer";
    public static final String TORCH_ENERGY_CONSUMPTION = "Energy Consumption";
    public static final String MAX_TORCH_STORAGE = "Maximum Storage Amount";
    public BlockTorch torch = AddonConfig.torch;

    public TorchPlacerModule(List validItems) {
        super(validItems);
        this.addBaseProperty(TORCH_ENERGY_CONSUMPTION, 50.0);
        this.addBaseProperty(MAX_TORCH_STORAGE, 64.0);
        this.addTradeoffProperty("Storage", MAX_TORCH_STORAGE, 192.0);
        this.addTradeoffProperty("Storage", TORCH_ENERGY_CONSUMPTION, 450.0);
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.controlCircuit, (int)1));
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.servoMotor, (int)2));
    }

    public String getTextureFile() {
        return "torchplacer";
    }

    public String getCategory() {
        return "Special";
    }

    public String getName() {
        return MODULE_TORCH_PLACER;
    }

    public String getDescription() {
        return "Stores torches in an internal storage and places them in the world on use.";
    }

    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        InventoryPlayer inv = player.field_71071_by;
        int torchesNeeded = (int)ModuleManager.computeModularProperty((ItemStack)item, (String)MAX_TORCH_STORAGE) - AddonUtils.getTorchLevel(item);
        if (torchesNeeded > 0) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || stack.field_77993_c != Block.field_72069_aq.field_71990_ca) continue;
                int loopTimes = torchesNeeded < stack.field_77994_a ? torchesNeeded : stack.field_77994_a;
                for (int i2 = 0; i2 < loopTimes; ++i2) {
                    AddonUtils.setTorchLevel(item, AddonUtils.getTorchLevel(item) + 1);
                    player.field_71071_by.func_70298_a(i, 1);
                    if (stack.field_77994_a != 0) continue;
                    player.field_71071_by.func_70299_a(i, null);
                }
                if (!(ModuleManager.computeModularProperty((ItemStack)item, (String)MAX_TORCH_STORAGE) - (double)AddonUtils.getTorchLevel(item) < 1.0)) continue;
                i = inv.func_70302_i_() + 1;
            }
        }
    }

    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    public void onRightClick(EntityPlayer player, World world, ItemStack item) {
    }

    public void onItemUse(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (AddonUtils.getTorchLevel(item) > 0) {
            if (player.func_82247_a(x, y, z, side, item) && Block.field_71973_m[Block.field_72069_aq.field_71990_ca].func_71930_b(world, x, y, z)) {
                int blockID = world.func_72798_a(x, y, z);
                if (!(blockID == Block.field_71998_bu.field_71990_ca || blockID == Block.field_71962_X.field_71990_ca || blockID == Block.field_71961_Y.field_71990_ca || Block.field_71973_m[blockID] != null && Block.field_71973_m[blockID].isBlockReplaceable(world, x, y, z))) {
                    x += side == 5 ? 1 : (side == 4 ? -1 : 0);
                    y += side == 1 ? 1 : (side == 0 ? -1 : 0);
                    z += side == 3 ? 1 : (side == 2 ? -1 : 0);
                }
                blockID = world.func_72798_a(x, y, z);
                if (world.func_72799_c(x, y, z) || Block.field_71973_m[blockID].isBlockReplaceable(world, x, y, z)) {
                    if (this.torch.func_71930_b(world, x, y, z)) {
                        world.func_72832_d(x, y, z, Block.field_72069_aq.field_71990_ca, this.getMetaForTorch(world, x, y, z, side), 2);
                        world.func_72898_h(x, y, z, Block.field_72069_aq.field_71990_ca);
                        Block.field_71973_m[Block.field_72069_aq.field_71990_ca].func_71861_g(world, x, y, z);
                        AddonUtils.setTorchLevel(item, AddonUtils.getTorchLevel(item) - 1);
                        ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (double)ModuleManager.computeModularProperty((ItemStack)item, (String)TORCH_ENERGY_CONSUMPTION));
                    } else if (AddonUtils.isClientSide()) {
                        player.func_70006_a("[MPSA] Cannot place a torch here. Torch level: " + AddonUtils.getTorchLevel(item) + "/" + (int)ModuleManager.computeModularProperty((ItemStack)item, (String)MAX_TORCH_STORAGE));
                    }
                } else if (AddonUtils.isClientSide()) {
                    player.func_70006_a("[MPSA] Cannot place a torch here. Torch level: " + AddonUtils.getTorchLevel(item) + "/" + (int)ModuleManager.computeModularProperty((ItemStack)item, (String)MAX_TORCH_STORAGE));
                }
            } else if (AddonUtils.isClientSide()) {
                player.func_70006_a("[MPSA] Cannot place a torch here. Torch level: " + AddonUtils.getTorchLevel(item) + "/" + (int)ModuleManager.computeModularProperty((ItemStack)item, (String)MAX_TORCH_STORAGE));
            }
        } else {
            player.func_70006_a("[MPSA] No torches!");
        }
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }

    public int getMetaForTorch(World world, int x, int y, int z, int side) {
        return Block.field_71973_m[Block.field_72069_aq.field_71990_ca].func_85104_a(world, x, y, z, side, (float)x, (float)y, (float)z, 0);
    }
}

