/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ThermalGeneratorModule
extends PowerModuleBase
implements IPlayerTickModule {
    public static final String MODULE_THERMAL_GENERATOR = "Thermal Generator";
    public static final String THERMAL_ENERGY_GENERATION = "Energy Generation";

    public ThermalGeneratorModule(List validItems) {
        super(validItems);
        this.addBaseProperty(THERMAL_ENERGY_GENERATION, 25.0);
        this.addBaseProperty("Weight", 1000.0);
        this.addTradeoffProperty("Energy Generated", THERMAL_ENERGY_GENERATION, 25.0, " Joules");
        this.addTradeoffProperty("Energy Generated", "Weight", 1000.0, "g");
        if (ModCompatability.isIndustrialCraftLoaded()) {
            this.addInstallCost(ModCompatability.getIC2Item((String)"geothermalGenerator"));
            this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.controlCircuit, (int)1));
        } else {
            this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.controlCircuit, (int)2));
            this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.basicPlating, (int)1));
        }
    }

    public String getTextureFile() {
        return "heatgenerator";
    }

    public String getCategory() {
        return "Energy";
    }

    public String getName() {
        return MODULE_THERMAL_GENERATOR;
    }

    public String getDescription() {
        return "Generate power from extreme amounts of heat.";
    }

    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        double currentHeat = MuseHeatUtils.getPlayerHeat((EntityPlayer)player);
        double maxHeat = MuseHeatUtils.getMaxHeat((EntityPlayer)player);
        if (player.field_70170_p.func_82737_E() % 20L == 0L) {
            if (player.func_70027_ad()) {
                ElectricItemUtils.givePlayerEnergy((EntityPlayer)player, (double)(4.0 * ModuleManager.computeModularProperty((ItemStack)item, (String)THERMAL_ENERGY_GENERATION)));
            } else if (currentHeat >= 200.0) {
                ElectricItemUtils.givePlayerEnergy((EntityPlayer)player, (double)(2.0 * ModuleManager.computeModularProperty((ItemStack)item, (String)THERMAL_ENERGY_GENERATION)));
            } else if (currentHeat / maxHeat >= 0.5) {
                ElectricItemUtils.givePlayerEnergy((EntityPlayer)player, (double)ModuleManager.computeModularProperty((ItemStack)item, (String)THERMAL_ENERGY_GENERATION));
            }
        }
    }

    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }
}

