/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class LightningModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_LIGHTNING = "Lightning Summoner";
    public static final String LIGHTNING_ENERGY_CONSUMPTION = "Lightning Energy Consumption";
    public static final String HEAT = "Lightning Heat Emission";

    public LightningModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.hvcapacitor, (int)1));
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.solenoid, (int)2));
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.fieldEmitter, (int)2));
        this.addBaseProperty(LIGHTNING_ENERGY_CONSUMPTION, 500000.0, "");
        this.addBaseProperty(HEAT, 100.0, "");
    }

    public String getTextureFile() {
        return "bluestar";
    }

    public String getCategory() {
        return "Weapon";
    }

    public String getName() {
        return MODULE_LIGHTNING;
    }

    public String getDescription() {
        return "Allows you to summon lightning for a large energy cost.";
    }

    public void onRightClick(EntityPlayer player, World world, ItemStack item) {
        double range = 64.0;
        double energyConsumption = ModuleManager.computeModularProperty((ItemStack)item, (String)LIGHTNING_ENERGY_CONSUMPTION);
        if (energyConsumption < ElectricItemUtils.getPlayerEnergy((EntityPlayer)player)) {
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (double)energyConsumption);
            MuseHeatUtils.heatPlayer((EntityPlayer)player, (double)ModuleManager.computeModularProperty((ItemStack)item, (String)HEAT));
            MovingObjectPosition MOP = MusePlayerUtils.doCustomRayTrace((World)player.field_70170_p, (EntityPlayer)player, (boolean)true, (double)range);
            world.func_72838_d((Entity)new EntityLightningBolt(player.field_70170_p, MOP.field_72307_f.field_72450_a, MOP.field_72307_f.field_72448_b, MOP.field_72307_f.field_72449_c));
        }
    }

    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }
}

