/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import andrew.powersuits.modules.PropertyModifierIntLinearAdditive;
import java.util.List;
import net.machinemuse.api.IPropertyModifier;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LeafBlowerModule
extends PowerModuleBase
implements IRightClickModule {
    private static final String MODULE_LEAF_BLOWER = "Leaf Blower";
    private static final String LEAF_BLOWER_ENERGY_CONSUMPTION = "Energy Consumption";
    private static final String PLANT_RADIUS = "Plant Radius";
    private static final String LEAF_RADIUS = "Leaf Radius";

    public LeafBlowerModule(List validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(Item.field_77703_o, 3));
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.solenoid, (int)1));
        this.addBaseProperty(LEAF_BLOWER_ENERGY_CONSUMPTION, 100.0, "J");
        this.addBaseProperty(PLANT_RADIUS, 1.0, "m");
        this.addBaseProperty(LEAF_RADIUS, 1.0, "m");
        this.addIntTradeoffProperty(PLANT_RADIUS, PLANT_RADIUS, 2.0, "m", 1, 0);
        this.addIntTradeoffProperty(LEAF_RADIUS, LEAF_RADIUS, 2.0, "m", 1, 0);
    }

    public PowerModuleBase addIntTradeoffProperty(String tradeoffName, String propertyName, double multiplier, String unit, int roundTo, int offset) {
        units.put(propertyName, unit);
        return this.addPropertyModifier(propertyName, (IPropertyModifier)new PropertyModifierIntLinearAdditive(tradeoffName, multiplier, roundTo, offset));
    }

    public String getCategory() {
        return "Tool";
    }

    public String getName() {
        return MODULE_LEAF_BLOWER;
    }

    public String getDescription() {
        return "Create a torrent of air to knock plants out of the ground and leaves off of trees.";
    }

    public String getTextureFile() {
        return "leafblower";
    }

    public void onRightClick(EntityPlayer player, World world, ItemStack item) {
    }

    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block tempBlock;
        int meta;
        int id;
        int k;
        int j;
        int i;
        int blockID = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[blockID];
        int plant = (int)ModuleManager.computeModularProperty((ItemStack)itemStack, (String)PLANT_RADIUS);
        int leaf = (int)ModuleManager.computeModularProperty((ItemStack)itemStack, (String)LEAF_RADIUS);
        int totalEnergyDrain = 0;
        if (block != null && block.isLeaves(world, x, y, z)) {
            for (i = -leaf; i < leaf; ++i) {
                for (j = -leaf; j < leaf; ++j) {
                    for (k = -leaf; k < leaf; ++k) {
                        id = world.func_72798_a(x + i, y + j, z + k);
                        meta = world.func_72805_g(x + i, y + j, z + k);
                        tempBlock = Block.field_71973_m[id];
                        if (tempBlock == null || !tempBlock.isLeaves(world, x + i, y + j, z + k)) continue;
                        if (tempBlock.canHarvestBlock(player, meta)) {
                            tempBlock.func_71893_a(world, player, x + i, y + j, z + k, meta);
                            totalEnergyDrain = (int)((double)totalEnergyDrain + ModuleManager.computeModularProperty((ItemStack)itemStack, (String)LEAF_BLOWER_ENERGY_CONSUMPTION));
                        }
                        world.func_94571_i(x + i, y + j, z + k);
                    }
                }
            }
        }
        for (i = -plant; i < plant; ++i) {
            for (j = -plant; j < plant; ++j) {
                for (k = -plant; k < plant; ++k) {
                    id = world.func_72798_a(x + i, y + j, z + k);
                    meta = world.func_72805_g(x + i, y + j, z + k);
                    tempBlock = Block.field_71973_m[id];
                    if (tempBlock == null || !(tempBlock instanceof BlockFlower) || !tempBlock.canHarvestBlock(player, meta)) continue;
                    tempBlock.func_71893_a(world, player, x + i, y + j, z + k, meta);
                    totalEnergyDrain = (int)((double)totalEnergyDrain + ModuleManager.computeModularProperty((ItemStack)itemStack, (String)LEAF_BLOWER_ENERGY_CONSUMPTION));
                    world.func_94571_i(x + i, y + j, z + k);
                }
            }
        }
        ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (double)totalEnergyDrain);
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }
}

