/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class KineticGeneratorModule
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public static final String MODULE_KINETIC_GENERATOR = "Kinetic Generator";
    public static final String KINETIC_ENERGY_GENERATION = "Energy Per 5 Blocks";
    public static final String KINETIC_HEAT_GENERATION = "Heat Generation";

    public KineticGeneratorModule(List validItems) {
        super(validItems);
        this.addBaseProperty(KINETIC_HEAT_GENERATION, 5.0);
        this.addBaseProperty("Weight", 1000.0);
        this.addBaseProperty(KINETIC_ENERGY_GENERATION, 200.0);
        this.addTradeoffProperty("Energy Generated", KINETIC_ENERGY_GENERATION, 600.0, " Joules");
        this.addTradeoffProperty("Energy Generated", "Weight", 3000.0, "g");
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.servoMotor, (int)2));
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.controlCircuit, (int)1));
    }

    public String getTextureFile() {
        return "kineticgen";
    }

    public String getCategory() {
        return "Energy";
    }

    public String getName() {
        return MODULE_KINETIC_GENERATOR;
    }

    public String getDescription() {
        return "Generate power with your movement.";
    }

    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (!player.field_70160_al) {
            double distance;
            boolean isNotWalking;
            NBTTagCompound tag = MuseItemUtils.getMuseItemTag((ItemStack)item);
            boolean bl = isNotWalking = player.field_70154_o != null || player.func_70090_H();
            if (!tag.func_74764_b("x") || isNotWalking) {
                tag.func_74768_a("x", (int)player.field_70165_t);
            }
            if (!tag.func_74764_b("z") || isNotWalking) {
                tag.func_74768_a("z", (int)player.field_70161_v);
            }
            if ((distance = Math.sqrt((tag.func_74762_e("x") - (int)player.field_70165_t) * (tag.func_74762_e("x") - (int)player.field_70165_t) + (tag.func_74762_e("z") - (int)player.field_70161_v) * (tag.func_74762_e("z") - (int)player.field_70161_v))) >= 5.0) {
                tag.func_74768_a("x", (int)player.field_70165_t);
                tag.func_74768_a("z", (int)player.field_70161_v);
                if (player.func_70051_ag()) {
                    ElectricItemUtils.givePlayerEnergy((EntityPlayer)player, (double)ModuleManager.computeModularProperty((ItemStack)item, (String)KINETIC_ENERGY_GENERATION));
                    MuseHeatUtils.heatPlayer((EntityPlayer)player, (double)ModuleManager.computeModularProperty((ItemStack)item, (String)KINETIC_HEAT_GENERATION));
                } else {
                    ElectricItemUtils.givePlayerEnergy((EntityPlayer)player, (double)(ModuleManager.computeModularProperty((ItemStack)item, (String)KINETIC_ENERGY_GENERATION) / 2.0));
                    MuseHeatUtils.heatPlayer((EntityPlayer)player, (double)(ModuleManager.computeModularProperty((ItemStack)item, (String)KINETIC_HEAT_GENERATION) / 2.0));
                }
            }
        }
    }

    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }
}

