/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import andrew.powersuits.common.AddonUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import java.text.DecimalFormat;
import java.util.List;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class EUReaderModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_EU_READER = "EU Reader";

    public EUReaderModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.controlCircuit, (int)1));
        this.addInstallCost(ModCompatability.getIC2Item((String)"ecMeter"));
    }

    public String getTextureFile() {
        return "eureader";
    }

    public String getCategory() {
        return "Energy";
    }

    public String getName() {
        return MODULE_EU_READER;
    }

    public String getDescription() {
        return "An IC2 EU Reader integrated in your power tool.";
    }

    public void onRightClick(EntityPlayer player, World world, ItemStack item) {
    }

    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if ((tileEntity instanceof IEnergySource || tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) && !FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            NBTTagCompound nbtData = AddonUtils.getNBTTag(itemStack);
            long currentTotalEnergyEmitted = EnergyNet.getForWorld((World)world).getTotalEnergyEmitted(tileEntity);
            long currentTotalEnergySunken = EnergyNet.getForWorld((World)world).getTotalEnergySunken(tileEntity);
            long currentMeasureTime = world.func_72820_D();
            if (nbtData.func_74762_e("lastMeasuredTileEntityX") != x || nbtData.func_74762_e("lastMeasuredTileEntityY") != y || nbtData.func_74762_e("lastMeasuredTileEntityZ") != z) {
                nbtData.func_74768_a("lastMeasuredTileEntityX", x);
                nbtData.func_74768_a("lastMeasuredTileEntityY", y);
                nbtData.func_74768_a("lastMeasuredTileEntityZ", z);
                player.func_70006_a("Starting new measurement");
            } else {
                long measurePeriod = currentMeasureTime - nbtData.func_74763_f("lastMeasureTime");
                if (measurePeriod < 1L) {
                    measurePeriod = 1L;
                }
                double deltaEmitted = (currentTotalEnergyEmitted - nbtData.func_74763_f("lastTotalEnergyEmitted")) / measurePeriod;
                double deltaSunken = (currentTotalEnergySunken - nbtData.func_74763_f("lastTotalEnergySunken")) / measurePeriod;
                DecimalFormat powerFormat = new DecimalFormat("0.##");
                player.func_70006_a("Measured power [EU/t]: " + powerFormat.format(deltaSunken) + " in " + powerFormat.format(deltaEmitted) + " out " + powerFormat.format(deltaSunken - deltaEmitted) + " gain" + " (avg. over " + measurePeriod + " ticks)");
            }
            nbtData.func_74772_a("lastTotalEnergyEmitted", currentTotalEnergyEmitted);
            nbtData.func_74772_a("lastTotalEnergySunken", currentTotalEnergySunken);
            nbtData.func_74772_a("lastMeasureTime", currentMeasureTime);
            return true;
        }
        return false;
    }

    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }
}

