/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes.logic;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogic;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeLogicTeleport
extends PipeLogic {
    private Pipe pipe;
    private boolean[] phasedBroadcastSignal = new boolean[4];
    private int frequency = 0;
    public byte state = 1;
    public String owner = "";
    public int[] network = new int[0];
    public boolean isPublic = false;

    public void setTile(TileGenericPipe tile) {
        super.setTile(tile);
        this.pipe = this.container.pipe;
    }

    public boolean blockActivated(EntityPlayer player) {
        if (!AdditionalPipes.proxy.isServer(player.field_70170_p)) {
            return true;
        }
        if (this.owner == null || "".equalsIgnoreCase(this.owner)) {
            this.owner = player.field_71092_bJ;
        }
        ItemStack equippedItem = player.func_71045_bC();
        player.openGui((Object)AdditionalPipes.instance, 1, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    public void updateEntity() {
        super.updateEntity();
        this.updatePhasedSignals();
    }

    public void setFrequency(int freq) {
        this.removePhasedSignals();
        this.frequency = freq;
        this.phasedBroadcastSignal = new boolean[4];
        this.updatePhasedSignals();
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void removePhasedSignals() {
        for (int i = 0; i < this.phasedBroadcastSignal.length; ++i) {
            if (!this.phasedBroadcastSignal[i]) continue;
            Integer[] integerArray = (Integer[])TeleportManager.instance.phasedSignals.get(this.frequency);
            int n = i;
            Integer n2 = integerArray[n];
            Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] - 1);
            AdditionalPipes.instance.logger.info("Removing signal " + this.frequency + " : " + i);
        }
    }

    public void updatePhasedSignals() {
        if (!TeleportManager.instance.phasedSignals.containsKey(this.frequency)) {
            Object[] signals = new Integer[4];
            Arrays.fill(signals, (Object)0);
            TeleportManager.instance.phasedSignals.put(this.frequency, signals);
        }
        for (int i = 0; i < this.pipe.broadcastSignal.length; ++i) {
            if (this.phasedBroadcastSignal[i] == this.pipe.broadcastSignal[i]) continue;
            Integer[] integerArray = (Integer[])TeleportManager.instance.phasedSignals.get(this.frequency);
            int n = i;
            Integer.valueOf(integerArray[n] + (this.pipe.broadcastSignal[i] ? 1 : -1));
            AdditionalPipes.instance.logger.info((this.pipe.broadcastSignal[i] ? "Adding signal " : "Removing signal ") + this.frequency + " : " + i);
            this.phasedBroadcastSignal[i] = this.pipe.broadcastSignal[i];
        }
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        Pipe pipe = null;
        if (tile instanceof TileGenericPipe) {
            pipe = ((TileGenericPipe)tile).pipe;
        }
        if (pipe != null && pipe.logic.getClass() == ((Object)((Object)this)).getClass()) {
            return false;
        }
        return pipe != null;
    }

    public boolean outputOpen(ForgeDirection to) {
        return this.container.isPipeConnected(to);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("freq", this.frequency);
        nbttagcompound.func_74774_a("state", this.state);
        nbttagcompound.func_74778_a("owner", this.owner);
        nbttagcompound.func_74757_a("isPublic", this.isPublic);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.frequency = nbttagcompound.func_74762_e("freq");
        this.state = nbttagcompound.func_74764_b("canReceive") ? (byte)(nbttagcompound.func_74767_n("canReceive") ? 3 : 1) : nbttagcompound.func_74771_c("state");
        this.owner = nbttagcompound.func_74779_i("owner");
        this.isPublic = nbttagcompound.func_74767_n("isPublic");
    }

    public static boolean canPlayerModifyPipe(EntityPlayer player, PipeLogicTeleport logic) {
        return logic.isPublic || logic.owner.equals(player.field_71092_bJ) || player.field_71075_bZ.field_75098_d;
    }
}

