/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes.logic;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicWood;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PipeLogicAdvancedWood
extends PipeLogic
implements IInventory {
    public ItemStack[] items = new ItemStack[9];
    public boolean exclude = false;

    public void switchSource() {
        int meta = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        int newMeta = 6;
        for (int i = meta + 1; i <= meta + 6; ++i) {
            ForgeDirection o = ForgeDirection.VALID_DIRECTIONS[i % 6];
            TileEntity tile = this.container.getTile(o);
            if (!this.isInput(tile) || !PipeManager.canExtractItems((Object)this.container.getPipe(), (World)tile.field_70331_k, (int)tile.field_70329_l, (int)tile.field_70330_m, (int)tile.field_70327_n)) continue;
            newMeta = o.ordinal();
            break;
        }
        if (newMeta != meta) {
            this.worldObj.func_72921_c(this.xCoord, this.yCoord, this.zCoord, newMeta, 2);
            this.container.scheduleRenderUpdate();
        }
    }

    public boolean isInput(TileEntity tile) {
        return !(tile instanceof TileGenericPipe) && tile instanceof IInventory && Utils.checkPipesConnections((TileEntity)this.container, (TileEntity)tile);
    }

    public boolean blockActivated(EntityPlayer entityplayer) {
        Item equipped;
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.xCoord, this.yCoord, this.zCoord)) {
            this.switchSource();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        if (AdditionalPipes.isPipe(equipped)) {
            return false;
        }
        entityplayer.openGui((Object)AdditionalPipes.instance, 3, this.container.field_70331_k, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        return true;
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        Pipe pipe2 = null;
        if (tile instanceof TileGenericPipe) {
            pipe2 = ((TileGenericPipe)tile).pipe;
        }
        return (pipe2 == null || !(pipe2.logic instanceof PipeLogicWood) && !(pipe2.logic instanceof PipeLogicAdvancedWood)) && super.canPipeConnect(tile, side);
    }

    public void initialize() {
        super.initialize();
        this.switchSourceIfNeeded();
    }

    private void switchSourceIfNeeded() {
        int meta = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        if (meta > 5) {
            this.switchSource();
        } else {
            TileEntity tile = this.container.getTile(ForgeDirection.VALID_DIRECTIONS[meta]);
            if (!this.isInput(tile)) {
                this.switchSource();
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.exclude = nbttagcompound.func_74767_n("exclude");
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("items");
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbttaglist.func_74743_b(j);
            int index = nbttagcompound2.func_74762_e("index");
            this.items[index] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2);
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("exclude", this.exclude);
        NBTTagList nbttaglist = new NBTTagList();
        for (int j = 0; j < this.items.length; ++j) {
            if (this.items[j] == null || this.items[j].field_77994_a <= 0) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
            nbttagcompound2.func_74768_a("index", j);
            this.items[j].func_77955_b(nbttagcompound2);
        }
        nbttagcompound.func_74782_a("items", (NBTBase)nbttaglist);
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack func_70298_a(int i, int amt) {
        ItemStack stack = this.func_70301_a(i);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(i, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack stack = this.func_70301_a(i);
        if (stack != null) {
            this.func_70299_a(i, null);
        }
        return stack;
    }

    public void func_70299_a(int i, ItemStack var2) {
        this.items[i] = var2;
    }

    public String func_70303_b() {
        return "item.PipeItemsAdvancedWood";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean doDrop() {
        Utils.dropItems((World)this.worldObj, (IInventory)this, (int)this.xCoord, (int)this.yCoord, (int)this.zCoord);
        return true;
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }
}

