/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.logic.PipeLogicTeleport;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;

public class TeleportManager {
    public static final TeleportManager instance = new TeleportManager();
    public final List teleportPipes = new LinkedList();
    public final Map phasedSignals = new HashMap();
    public final Map frequencyNames = new HashMap();

    private TeleportManager() {
    }

    public void add(PipeTeleport pipe) {
        if (!AdditionalPipes.proxy.isServer(pipe.worldObj)) {
            return;
        }
        this.teleportPipes.add(pipe);
        AdditionalPipes.instance.logger.info(String.format("[TeleportManager] Pipe added: %s @ (%d, %d, %d), %d pipes in network", ((Object)((Object)pipe)).getClass().getSimpleName(), pipe.xCoord, pipe.yCoord, pipe.zCoord, this.teleportPipes.size()));
    }

    public void remove(PipeTeleport pipe) {
        if (!AdditionalPipes.proxy.isServer(pipe.worldObj)) {
            return;
        }
        this.teleportPipes.remove((Object)pipe);
        AdditionalPipes.instance.logger.info(String.format("[TeleportManager] Pipe removed: %s @ (%d, %d, %d), %d pipes in network", ((Object)((Object)pipe)).getClass().getSimpleName(), pipe.xCoord, pipe.yCoord, pipe.zCoord, this.teleportPipes.size()));
    }

    public void reset() {
        this.teleportPipes.clear();
        this.phasedSignals.clear();
        this.frequencyNames.clear();
        AdditionalPipes.instance.logger.info("Reset teleport manager.");
    }

    public List getConnectedPipes(PipeTeleport pipe, boolean forceReceive) {
        LinkedList<PipeTeleport> connected = new LinkedList<PipeTeleport>();
        PipeLogicTeleport logic = pipe.logic;
        for (PipeTeleport other : this.teleportPipes) {
            if (!((Object)((Object)pipe)).getClass().equals(((Object)((Object)other)).getClass()) || other.container.func_70320_p()) continue;
            PipeLogicTeleport otherLogic = other.logic;
            if (pipe.xCoord == other.xCoord && pipe.yCoord == other.yCoord && pipe.zCoord == other.zCoord || otherLogic.getFrequency() != logic.getFrequency() || (otherLogic.state & 2) <= 0 && !forceReceive || !(logic.isPublic ? otherLogic.isPublic : otherLogic.owner.equalsIgnoreCase(logic.owner))) continue;
            connected.add(other);
        }
        return connected;
    }

    public List getAllPipesInNetwork(PipeTeleport pipe) {
        LinkedList<PipeTeleport> pipes = new LinkedList<PipeTeleport>();
        PipeLogicTeleport logic = pipe.logic;
        for (PipeTeleport other : this.teleportPipes) {
            PipeLogicTeleport otherLogic;
            if (!((Object)((Object)pipe)).getClass().equals(((Object)((Object)other)).getClass()) || other.container.func_70320_p() || (otherLogic = other.logic).getFrequency() != logic.getFrequency() || !(logic.isPublic ? otherLogic.isPublic : otherLogic.owner.equalsIgnoreCase(logic.owner))) continue;
            pipes.add(other);
        }
        return pipes;
    }

    public String getFrequencyName(int frequency) {
        String name = (String)this.frequencyNames.get(frequency);
        return name == null ? "" : name;
    }

    public void setFrequencyName(int frequency, String name) {
        this.frequencyNames.put(frequency, name);
    }

    public File getWorldSave(World world) {
        return world.func_72860_G().func_75758_b("foo").getParentFile().getParentFile();
    }
}

