/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.pipes.logic.PipeLogicTeleport;
import buildcraft.core.utils.Utils;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipePowerTeleport
extends PipeTeleport
implements IPipeTransportPowerHook {
    public PipePowerTeleport(int itemID) {
        super((PipeTransport)new PipeTransportPower(), new PipeLogicTeleport(), itemID);
    }

    public void requestEnergy(ForgeDirection from, int is) {
        ((PipeTransportPower)this.transport).step();
        if ((this.logic.state & 2) == 0) {
            return;
        }
        List pipeList = TeleportManager.instance.getConnectedPipes(this, true);
        if (pipeList.size() <= 0) {
            return;
        }
        for (PipeTeleport pipe : pipeList) {
            LinkedList possibleMovements = PipePowerTeleport.getRealPossibleMovements(pipe);
            for (ForgeDirection orientation : possibleMovements) {
                TileEntity tile = pipe.container.getTile(orientation);
                if (!(tile instanceof TileGenericPipe)) continue;
                TileGenericPipe adjacentTile = (TileGenericPipe)tile;
                PipeTransportPower nearbyTransport = (PipeTransportPower)adjacentTile.pipe.transport;
                nearbyTransport.requestEnergy(orientation.getOpposite(), is);
            }
        }
    }

    public double receiveEnergy(ForgeDirection from, double energy) {
        ((PipeTransportPower)this.transport).step();
        List connectedPipes = TeleportManager.instance.getConnectedPipes(this, false);
        LinkedList<PipeTeleport> sendingToList = new LinkedList<PipeTeleport>();
        if (connectedPipes.size() <= 0 || (this.logic.state & 1) == 0) {
            return 0.0;
        }
        for (PipeTeleport pipe : connectedPipes) {
            if (this.getPipesNeedsPower(pipe).size() <= 0) continue;
            sendingToList.add(pipe);
        }
        if (sendingToList.size() <= 0) {
            return 0.0;
        }
        double powerToSend = AdditionalPipes.instance.powerLossCfg * energy / (double)sendingToList.size();
        for (PipeTeleport receiver : sendingToList) {
            List needsPower = this.getPipesNeedsPower(receiver);
            if (needsPower.size() <= 0) continue;
            double dividedPowerToSend = powerToSend / (double)needsPower.size();
            for (PowerRequest powerEntry : needsPower) {
                PipeTransportPower nearbyTransport = (PipeTransportPower)powerEntry.tile.pipe.transport;
                nearbyTransport.receiveEnergy(powerEntry.orientation, dividedPowerToSend);
            }
        }
        return energy;
    }

    private List getPipesNeedsPower(PipeTeleport pipe) {
        LinkedList possibleMovements = PipePowerTeleport.getRealPossibleMovements(pipe);
        LinkedList<PowerRequest> needsPower = new LinkedList<PowerRequest>();
        if (possibleMovements.size() > 0) {
            for (ForgeDirection orientation : possibleMovements) {
                TileGenericPipe adjacentPipe;
                TileEntity tile = pipe.container.getTile(orientation);
                if (!(tile instanceof TileGenericPipe) || !PipePowerTeleport.pipeNeedsPower(adjacentPipe = (TileGenericPipe)tile)) continue;
                needsPower.add(new PowerRequest(adjacentPipe, orientation.getOpposite()));
            }
        }
        return needsPower;
    }

    private static boolean pipeNeedsPower(TileGenericPipe tile) {
        if (tile instanceof TileGenericPipe) {
            PipeTransportPower ttb = (PipeTransportPower)tile.pipe.transport;
            for (int i = 0; i < ttb.powerQuery.length; ++i) {
                if (ttb.powerQuery[i] <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private static LinkedList getRealPossibleMovements(PipeTeleport pipe) {
        LinkedList<ForgeDirection> result = new LinkedList<ForgeDirection>();
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te;
            if (!pipe.outputOpen(orientation) || !((te = pipe.container.getTile(orientation)) instanceof TileGenericPipe) || !Utils.checkPipesConnections((TileEntity)pipe.container, (TileEntity)te)) continue;
            result.add(orientation);
        }
        return result;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 3;
    }

    private static class PowerRequest {
        public final TileGenericPipe tile;
        public final ForgeDirection orientation;

        public PowerRequest(TileGenericPipe te, ForgeDirection o) {
            this.tile = te;
            this.orientation = o;
        }
    }
}

