/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.pipes.logic.PipeLogicTeleport;
import buildcraft.transport.IPipeTransportLiquidsHook;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportLiquids;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidsTeleport
extends PipeTeleport
implements IPipeTransportLiquidsHook {
    public PipeLiquidsTeleport(int itemID) {
        super((PipeTransport)new PipeTransportLiquids(), new PipeLogicTeleport(), itemID);
        ((PipeTransportLiquids)this.transport).flowRate = (short)160;
        ((PipeTransportLiquids)this.transport).travelDelay = (short)4;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        List pipeList = TeleportManager.instance.getConnectedPipes(this, false);
        if (pipeList.size() == 0 || (this.logic.state & 1) == 0) {
            return 0;
        }
        int i = this.worldObj.field_73012_v.nextInt(pipeList.size());
        List possibleMovements = PipeLiquidsTeleport.getPossibleLiquidMovements((PipeTeleport)((Object)pipeList.get(i)));
        if (possibleMovements.size() <= 0) {
            return 0;
        }
        int used = 0;
        while (possibleMovements.size() > 0 && used <= 0) {
            int a = rand.nextInt(possibleMovements.size());
            used = ((ITankContainer)possibleMovements.get(a)).fill(ForgeDirection.UNKNOWN, resource, doFill);
            possibleMovements.remove(a);
        }
        return used;
    }

    private static List getPossibleLiquidMovements(PipeTeleport pipe) {
        LinkedList<ITankContainer> result = new LinkedList<ITankContainer>();
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!pipe.logic.outputOpen(o)) continue;
            ITankContainer te = (ITankContainer)pipe.container.getTile(o);
            result.add(te);
        }
        return result;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 2;
    }
}

