/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipeEntry;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.utils.Utils;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicGold;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidsRedstone
extends APPipe {
    @TileNetworkData
    public boolean isPowering = false;

    public PipeLiquidsRedstone(int itemID) {
        super((PipeTransport)new PipeTransportLiquids(), (PipeLogic)new PipeLogicGold(), itemID);
        ((PipeTransportLiquids)this.transport).flowRate = (short)80;
        ((PipeTransportLiquids)this.transport).travelDelay = (short)2;
    }

    private void UpdateTiles(int i, int j, int k) {
        this.worldObj.func_72898_h(i, j, k, BuildCraftTransport.genericPipeBlock.field_71990_ca);
    }

    public int isPoweringTo(int l) {
        LiquidStack liquid = ((PipeTransportLiquids)this.transport).getTanks(ForgeDirection.UNKNOWN)[ForgeDirection.UNKNOWN.ordinal()].getLiquid();
        if (liquid == null || liquid.amount == 0) {
            this.isPowering = false;
            return 0;
        }
        this.isPowering = true;
        int i1 = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        if (i1 == 5 && l == 1) {
            return 0;
        }
        if (i1 == 3 && l == 3) {
            return 0;
        }
        if (i1 == 4 && l == 2) {
            return 0;
        }
        if (i1 == 1 && l == 5) {
            return 0;
        }
        return i1 != 2 || l != 4 ? 15 : 0;
    }

    public int isIndirectlyPoweringTo(int l) {
        return this.isPoweringTo(l);
    }

    public void updateEntity() {
        super.updateEntity();
        LiquidStack liquid = ((PipeTransportLiquids)this.transport).getTanks(ForgeDirection.UNKNOWN)[ForgeDirection.UNKNOWN.ordinal()].getLiquid();
        if (liquid == null || liquid.amount == 0 && this.isPowering) {
            this.isPowering = false;
            this.UpdateTiles(this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        } else if (!this.isPowering) {
            this.isPowering = true;
            this.UpdateTiles(this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        }
    }

    public boolean canRec(Position p) {
        TileEntity entity = this.worldObj.func_72796_p((int)p.x, (int)p.y, (int)p.z);
        if (!Utils.checkPipesConnections((TileEntity)entity, (TileEntity)this.container)) {
            return false;
        }
        return entity instanceof IPipeEntry || entity instanceof ITankContainer;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return this.isPowering ? 15 : 1;
    }
}

