/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.additionalpipes.pipes.logic.PipeLogicDistributor;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsDistributor
extends APPipe
implements IPipeTransportItemsHook {
    public final PipeLogicDistributor logic;

    public PipeItemsDistributor(int itemID) {
        super((PipeTransport)new PipeTransportItems(), new PipeLogicDistributor(), itemID);
        this.logic = (PipeLogicDistributor)((APPipe)this).logic;
    }

    @Override
    public int getIconIndex(ForgeDirection connection) {
        switch (connection) {
            case DOWN: {
                return 10;
            }
            case UP: {
                return 11;
            }
            case NORTH: {
                return 12;
            }
            case SOUTH: {
                return 13;
            }
            case WEST: {
                return 14;
            }
        }
        return 9;
    }

    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        LinkedList<ForgeDirection> result = new LinkedList<ForgeDirection>();
        if (this.logic.curTick >= this.logic.distData[this.logic.distSide]) {
            this.toNextOpenSide();
        }
        result.add(ForgeDirection.VALID_DIRECTIONS[this.logic.distSide]);
        this.logic.curTick += item.getItemStack().field_77994_a;
        return result;
    }

    private void toNextOpenSide() {
        this.logic.curTick = 0;
        for (int o = 0; o < this.logic.distData.length; ++o) {
            this.logic.distSide = (this.logic.distSide + 1) % this.logic.distData.length;
            if (this.logic.distData[this.logic.distSide] > 0 && this.container.isPipeConnected(ForgeDirection.VALID_DIRECTIONS[this.logic.distSide])) break;
        }
    }

    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
    }

    public void readjustSpeed(IPipedItem item) {
    }
}

