/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.additionalpipes.pipes.logic.PipeLogicAdvancedWood;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.IPipedItem;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class PipeItemsAdvancedWood
extends APPipe
implements IPowerReceptor {
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    public PipeItemsAdvancedWood(int itemID) {
        super((PipeTransport)new PipeTransportItems(), new PipeLogicAdvancedWood(), itemID);
        this.powerProvider.configure(50, 1, 64, 1, 64);
        this.powerProvider.configurePowerPerdition(64, 1);
    }

    public void setPowerProvider(IPowerProvider provider) {
        provider = this.powerProvider;
    }

    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    public void doWork() {
        if (this.powerProvider.getEnergyStored() <= 0.0f) {
            return;
        }
        World w = this.worldObj;
        int meta = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        if (meta > 5) {
            return;
        }
        Position pos = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, ForgeDirection.VALID_DIRECTIONS[meta]);
        pos.moveForwards(1.0);
        int blockId = w.func_72798_a((int)pos.x, (int)pos.y, (int)pos.z);
        TileEntity tile = w.func_72796_p((int)pos.x, (int)pos.y, (int)pos.z);
        if (tile instanceof IInventory) {
            if (!PipeManager.canExtractItems((Object)((Object)this), (World)w, (int)((int)pos.x), (int)((int)pos.y), (int)((int)pos.z))) {
                return;
            }
            IInventory inventory = (IInventory)tile;
            ItemStack extracted = this.checkExtract(inventory, true, pos.orientation.getOpposite());
            if (extracted == null || extracted.field_77994_a == 0) {
                this.powerProvider.useEnergy(1.0f, 1.0f, false);
                return;
            }
            Position entityPos = new Position(pos.x + 0.5, pos.y + (double)Utils.getPipeFloorOf((ItemStack)extracted), pos.z + 0.5, pos.orientation.getOpposite());
            entityPos.moveForwards(0.5);
            EntityPassiveItem entity = new EntityPassiveItem(w, entityPos.x, entityPos.y, entityPos.z, extracted);
            ((PipeTransportItems)this.transport).entityEntering((IPipedItem)entity, entityPos.orientation);
        }
    }

    public ItemStack checkExtract(IInventory inventory, boolean doRemove, ForgeDirection from) {
        IInventory inv = Utils.getInventory((IInventory)inventory);
        int first = 0;
        int last = inv.func_70302_i_() - 1;
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            first = sidedInv.getStartInventorySide(from);
            last = first + sidedInv.getSizeInventorySide(from) - 1;
        } else if (inventory instanceof net.minecraft.inventory.ISidedInventory) {
            net.minecraft.inventory.ISidedInventory sidedInv = (net.minecraft.inventory.ISidedInventory)inventory;
            int[] accessibleSlots = sidedInv.func_94128_d(from.ordinal());
            ItemStack result = this.checkExtractGeneric(inv, doRemove, from, accessibleSlots);
            return result;
        }
        ItemStack result = this.checkExtractGeneric(inv, doRemove, from, first, last);
        return result;
    }

    public ItemStack checkExtractGeneric(IInventory inventory, boolean doRemove, ForgeDirection from, int start, int stop) {
        for (int k = start; k <= stop; ++k) {
            ItemStack slot = inventory.func_70301_a(k);
            if (slot == null || slot.field_77994_a <= 0 || !this.canExtract(slot)) continue;
            if (doRemove) {
                return inventory.func_70298_a(k, (int)this.powerProvider.useEnergy(1.0f, (float)slot.field_77994_a, true));
            }
            return slot;
        }
        return null;
    }

    public ItemStack checkExtractGeneric(IInventory inventory, boolean doRemove, ForgeDirection from, int[] slots) {
        for (int i : slots) {
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null || slot.field_77994_a <= 0 || !this.canExtract(slot)) continue;
            if (doRemove) {
                return inventory.func_70298_a(i, (int)this.powerProvider.useEnergy(1.0f, (float)slot.field_77994_a, true));
            }
            return slot;
        }
        return null;
    }

    public boolean canExtract(ItemStack item) {
        PipeLogicAdvancedWood logic = (PipeLogicAdvancedWood)this.logic;
        for (int i = 0; i < logic.func_70302_i_(); ++i) {
            ItemStack stack = logic.func_70301_a(i);
            if (stack == null || stack.field_77993_c != item.field_77993_c) continue;
            if (Item.field_77698_e[item.field_77993_c].func_77645_m()) {
                return !logic.exclude;
            }
            if (stack.func_77960_j() != item.func_77960_j()) continue;
            return !logic.exclude;
        }
        return logic.exclude;
    }

    public int powerRequest(ForgeDirection from) {
        return this.getPowerProvider().getMaxEnergyReceived();
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return 6;
        }
        int metadata = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        if (metadata == direction.ordinal()) {
            return 7;
        }
        return 6;
    }
}

