/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.network;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.network.PacketNBTTagData;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.logic.PipeLogicAdvancedWood;
import buildcraft.additionalpipes.pipes.logic.PipeLogicDistributor;
import buildcraft.additionalpipes.pipes.logic.PipeLogicTeleport;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogic;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;

public class NetworkHandler
implements IPacketHandler {
    public static final byte CHUNKLOAD_DATA = 15;
    public static final byte TELE_PIPE_DATA = 16;
    public static final byte ADV_WOOD_DATA = 62;
    public static final byte DIST_PIPE_DATA = 63;
    public static final byte TELE_PIPE_DATA_SET = 64;
    public static final byte CHUNKLOAD_REQUEST = 65;

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        if ("APUnofficial".equals(packet.field_73630_a)) {
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
            int packetID = -1;
            try {
                packetID = data.readByte();
                switch (packetID) {
                    case 62: {
                        TileEntity te = this.getTileEntity(player, data);
                        if (!(te instanceof TileGenericPipe)) break;
                        PipeLogic logic = ((TileGenericPipe)te).pipe.logic;
                        PipeLogicAdvancedWood advLogic = (PipeLogicAdvancedWood)logic;
                        advLogic.exclude = !advLogic.exclude;
                        break;
                    }
                    case 63: {
                        this.handleDistPipeData(player, data);
                        break;
                    }
                    case 64: {
                        this.handleTelePipeData(player, data);
                        break;
                    }
                    case 15: {
                        this.handleChunkLoadData(data);
                        break;
                    }
                    case 65: {
                        AdditionalPipes.instance.chunkLoadViewer.sendPersistentChunksToPlayer((EntityPlayerMP)player);
                    }
                }
            }
            catch (IOException e) {
                AdditionalPipes.instance.logger.log(Level.SEVERE, "Error handling packet " + packetID, e);
            }
        } else if ("APUnofficialNBT".equals(packet.field_73630_a)) {
            NBTTagCompound tag = PacketNBTTagData.getNBTFrom(packet);
            switch (tag.func_74762_e("id")) {
                case 16: {
                    TileEntity te = ((EntityPlayer)player).field_70170_p.func_72796_p(tag.func_74762_e("xCoord"), tag.func_74762_e("yCoord"), tag.func_74762_e("zCoord"));
                    if (!(te instanceof TileGenericPipe)) break;
                    PipeTeleport pipe = (PipeTeleport)((TileGenericPipe)te).pipe;
                    pipe.logic.owner = tag.func_74779_i("owner");
                    pipe.logic.network = tag.func_74759_k("network");
                }
            }
        }
    }

    private void handleDistPipeData(Player player, DataInputStream data) {
        try {
            TileEntity te = this.getTileEntity(player, data);
            if (te instanceof TileGenericPipe) {
                int index = data.read();
                int newData = data.readInt();
                PipeLogicDistributor logic = (PipeLogicDistributor)((TileGenericPipe)te).pipe.logic;
                if (newData >= 0 && index >= 0 && index < logic.distData.length) {
                    int i;
                    boolean found;
                    logic.distData[index] = newData;
                    boolean bl = found = newData > 0;
                    if (!found) {
                        for (i = 0; i < logic.distData.length; ++i) {
                            if (logic.distData[i] <= 0) continue;
                            found = true;
                        }
                    }
                    if (!found) {
                        for (i = 0; i < logic.distData.length; ++i) {
                            logic.distData[i] = 1;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            AdditionalPipes.instance.logger.log(Level.SEVERE, "Error handling distribution pipe packet.", e);
        }
    }

    private void handleTelePipeData(Player player, DataInputStream data) {
        try {
            TileEntity te = this.getTileEntity(player, data);
            if (te instanceof TileGenericPipe) {
                PipeTeleport pipe = (PipeTeleport)((TileGenericPipe)te).pipe;
                EntityPlayerMP entityPlayer = (EntityPlayerMP)player;
                if (!PipeLogicTeleport.canPlayerModifyPipe((EntityPlayer)entityPlayer, pipe.logic)) {
                    entityPlayer.func_70006_a("You may not change pipe state.");
                    return;
                }
                int frequency = data.readInt();
                if (frequency < 0) {
                    frequency = 0;
                }
                pipe.logic.setFrequency(frequency);
                pipe.logic.state = (byte)data.read();
                pipe.logic.isPublic = data.read() == 1;
            }
        }
        catch (IOException e) {
            AdditionalPipes.instance.logger.log(Level.SEVERE, "Error handling teleport pipe packet.", e);
        }
    }

    private void handleChunkLoadData(DataInputStream data) {
        try {
            int size = data.readInt();
            ChunkCoordIntPair[] chunks = new ChunkCoordIntPair[size];
            for (int i = 0; i < size; ++i) {
                chunks[i] = new ChunkCoordIntPair(data.readInt(), data.readInt());
            }
            AdditionalPipes.instance.chunkLoadViewer.receivePersistentChunks(chunks);
        }
        catch (IOException e) {
            AdditionalPipes.instance.logger.log(Level.SEVERE, "Error handling chunk load data.", e);
        }
    }

    public TileEntity getTileEntity(Player player, DataInputStream data) {
        TileEntity te = null;
        try {
            int x = data.readInt();
            int y = data.readInt();
            int z = data.readInt();
            te = ((EntityPlayer)player).field_70170_p.func_72796_p(x, y, z);
        }
        catch (IOException e) {
            AdditionalPipes.instance.logger.log(Level.SEVERE, "Error getting tileentity position from packet.", e);
        }
        return te;
    }
}

