/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.gui;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.network.PacketNBTTagData;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;

public class ContainerTeleportPipe
extends BuildCraftContainer {
    public int connectedPipes = 0;
    private int ticks = 0;
    private PipeTeleport pipe;
    private int freq;
    private byte state;
    private boolean isPublic;

    public ContainerTeleportPipe(EntityPlayer player, TileGenericPipe tile) {
        super(0);
        this.pipe = (PipeTeleport)tile.pipe;
        this.state = (byte)-1;
        this.isPublic = !this.pipe.logic.isPublic;
        this.freq = -1;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("id", 16);
        tag.func_74768_a("xCoord", this.pipe.xCoord);
        tag.func_74768_a("yCoord", this.pipe.yCoord);
        tag.func_74768_a("zCoord", this.pipe.zCoord);
        tag.func_74778_a("owner", this.pipe.logic.owner);
        List pipes = TeleportManager.instance.getConnectedPipes(this.pipe, false);
        int[] locations = new int[pipes.size() * 3];
        for (int i = 0; i < pipes.size() && i < 9; ++i) {
            Pipe pipe = (Pipe)pipes.get(i);
            locations[3 * i] = pipe.xCoord;
            locations[3 * i + 1] = pipe.yCoord;
            locations[3 * i + 2] = pipe.zCoord;
        }
        tag.func_74783_a("network", locations);
        PacketNBTTagData packet = new PacketNBTTagData("APUnofficialNBT", 16, false, tag);
        PacketDispatcher.sendPacketToPlayer((Packet)packet.getPacket(), (Player)((Player)player));
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void func_75142_b() {
        super.func_75142_b();
        int connectedPipesNew = this.connectedPipes;
        if (this.ticks % 40 == 0) {
            this.ticks = 0;
            AdditionalPipes.instance.logger.info("Old connected:" + connectedPipesNew);
            connectedPipesNew = TeleportManager.instance.getConnectedPipes(this.pipe, false).size();
            AdditionalPipes.instance.logger.info("New connected:" + connectedPipesNew);
        }
        ++this.ticks;
        for (Object crafter : this.field_75149_d) {
            if (this.freq != this.pipe.logic.getFrequency()) {
                ((ICrafting)crafter).func_71112_a((Container)this, 0, this.pipe.logic.getFrequency());
            }
            if (this.state != this.pipe.logic.state) {
                ((ICrafting)crafter).func_71112_a((Container)this, 1, (int)this.pipe.logic.state);
            }
            if (connectedPipesNew != this.connectedPipes) {
                ((ICrafting)crafter).func_71112_a((Container)this, 2, connectedPipesNew);
            }
            if (this.isPublic == this.pipe.logic.isPublic) continue;
            ((ICrafting)crafter).func_71112_a((Container)this, 3, this.pipe.logic.isPublic ? 1 : 0);
        }
        this.state = this.pipe.logic.state;
        this.freq = this.pipe.logic.getFrequency();
        this.isPublic = this.pipe.logic.isPublic;
        this.connectedPipes = connectedPipesNew;
    }

    public void func_75137_b(int i, int j) {
        switch (i) {
            case 0: {
                this.pipe.logic.setFrequency(j);
                break;
            }
            case 1: {
                this.pipe.logic.state = (byte)j;
                break;
            }
            case 2: {
                this.connectedPipes = j;
                break;
            }
            case 3: {
                this.pipe.logic.isPublic = j == 1;
            }
        }
    }
}

