/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.render.RenderEntityBlock;
import buildcraft.transport.EntityData;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class RenderPipe
extends TileEntitySpecialRenderer {
    private static final int LIQUID_STAGES = 40;
    private static final int MAX_ITEMS_TO_RENDER = 10;
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private final RenderItem customRenderItem;
    private final HashMap displayLiquidLists = new HashMap();
    private final int[] angleY = new int[]{0, 0, 270, 90, 0, 180};
    private final int[] angleZ = new int[]{90, 270, 0, 0, 0, 0};
    private static final int POWER_STAGES = 100;
    public int[] displayPowerList = new int[100];
    public int[] displayPowerListOverload = new int[100];
    boolean initialized = false;

    public RenderPipe() {
        this.customRenderItem = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.customRenderItem.func_76976_a(RenderManager.field_78727_a);
    }

    private DisplayLiquidList getDisplayLiquidLists(int liquidId, int meta, World world) {
        if (this.displayLiquidLists.containsKey(liquidId)) {
            HashMap x = (HashMap)this.displayLiquidLists.get(liquidId);
            if (x.containsKey(meta)) {
                return (DisplayLiquidList)x.get(meta);
            }
        } else {
            this.displayLiquidLists.put(liquidId, new HashMap());
        }
        DisplayLiquidList d = new DisplayLiquidList();
        ((HashMap)this.displayLiquidLists.get(liquidId)).put(meta, d);
        RenderEntityBlock.BlockInterface block = new RenderEntityBlock.BlockInterface();
        if (liquidId < Block.field_71973_m.length && Block.field_71973_m[liquidId] != null) {
            block.baseBlock = Block.field_71973_m[liquidId];
        } else {
            block.baseBlock = Block.field_71943_B;
            block.texture = Item.field_77698_e[liquidId].func_77617_a(meta);
        }
        float size = 0.5f;
        for (int s = 0; s < 40; ++s) {
            float ratio = (float)s / 40.0f;
            d.sideHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideHorizontal[s], (int)4864);
            block.minX = 0.0;
            block.minZ = 0.26f;
            block.maxX = block.minX + (double)(size / 2.0f) + (double)0.01f;
            block.maxZ = block.minZ + (double)size - (double)0.02f;
            block.minY = 0.26f;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.sideVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideVertical[s], (int)4864);
            block.minY = 0.74;
            block.maxY = 1.0;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            RenderEntityBlock.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerHorizontal[s], (int)4864);
            block.minX = 0.26;
            block.minZ = 0.26;
            block.maxX = block.minX + (double)size - 0.02;
            block.maxZ = block.minZ + (double)size - 0.02;
            block.minY = 0.26;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerVertical[s], (int)4864);
            block.minY = 0.26;
            block.maxY = 0.74;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            RenderEntityBlock.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        return d;
    }

    private void initializeDisplayPowerList(World world) {
        float unit;
        float minSize;
        int s;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        RenderEntityBlock.BlockInterface block = new RenderEntityBlock.BlockInterface();
        block.texture = BuildCraftTransport.instance.pipeIconProvider.getIcon(31);
        float size = 0.5f;
        for (s = 0; s < 100; ++s) {
            this.displayPowerList[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.displayPowerList[s], (int)4864);
            minSize = 0.005f;
            unit = (size - minSize) / 2.0f / 100.0f;
            block.minY = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxY = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minZ = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxZ = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minX = 0.0;
            block.maxX = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            RenderEntityBlock.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        block.texture = BuildCraftTransport.instance.pipeIconProvider.getIcon(32);
        size = 0.5f;
        for (s = 0; s < 100; ++s) {
            this.displayPowerListOverload[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.displayPowerListOverload[s], (int)4864);
            minSize = 0.005f;
            unit = (size - minSize) / 2.0f / 100.0f;
            block.minY = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxY = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minZ = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxZ = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minX = 0.0;
            block.maxX = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            RenderEntityBlock.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
    }

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        this.initializeDisplayPowerList(tileentity.field_70331_k);
        TileGenericPipe pipe = (TileGenericPipe)tileentity;
        if (pipe.pipe == null) {
            return;
        }
        if (pipe.pipe.transport instanceof PipeTransportItems) {
            this.renderSolids(pipe.pipe, x, y, z);
        } else if (pipe.pipe.transport instanceof PipeTransportLiquids) {
            this.renderLiquids(pipe.pipe, x, y, z);
        } else if (pipe.pipe.transport instanceof PipeTransportPower) {
            this.renderPower(pipe.pipe, x, y, z);
        }
    }

    private void renderPower(Pipe pipe, double x, double y, double z) {
        PipeTransportPower pow = (PipeTransportPower)pipe.transport;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_76897_a("/terrain.png");
        int[] displayList = pow.overload ? this.displayPowerListOverload : this.displayPowerList;
        for (int i = 0; i < 6; ++i) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if ((double)pow.displayPower[i] >= 1.0) {
                short stage = pow.displayPower[i];
                if (stage < displayList.length) {
                    GL11.glCallList((int)displayList[stage]);
                } else {
                    GL11.glCallList((int)displayList[displayList.length - 1]);
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private void renderLiquids(Pipe pipe, double x, double y, double z) {
        DisplayLiquidList d;
        PipeTransportLiquids liq = (PipeTransportLiquids)pipe.transport;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        boolean sides = false;
        boolean above = false;
        for (int i = 0; i < 6; ++i) {
            DisplayLiquidList d2;
            LiquidStack liquid = liq.renderCache[i];
            if (liquid == null || liquid.amount <= 0 || (d2 = this.getListFromBuffer(liquid, pipe.worldObj)) == null) continue;
            int stage = (int)((float)liquid.amount / (float)liq.getCapacity() * 39.0f);
            GL11.glPushMatrix();
            int list = 0;
            switch (ForgeDirection.VALID_DIRECTIONS[i]) {
                case UP: {
                    above = true;
                    list = d2.sideVertical[stage];
                    break;
                }
                case DOWN: {
                    GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
                    list = d2.sideVertical[stage];
                    break;
                }
                case EAST: 
                case WEST: 
                case SOUTH: 
                case NORTH: {
                    sides = true;
                    GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
                    GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
                    list = d2.sideHorizontal[stage];
                    break;
                }
            }
            this.func_76897_a(liquid.canonical().getTextureSheet());
            GL11.glCallList((int)list);
            GL11.glPopMatrix();
        }
        LiquidStack liquid = liq.renderCache[ForgeDirection.UNKNOWN.ordinal()];
        if (liquid != null && liquid.amount > 0 && (d = this.getListFromBuffer(liquid, pipe.worldObj)) != null) {
            int stage = (int)((float)liquid.amount / (float)liq.getCapacity() * 39.0f);
            this.func_76897_a(liquid.canonical().getTextureSheet());
            if (above) {
                GL11.glCallList((int)d.centerVertical[stage]);
            }
            if (!above || sides) {
                GL11.glCallList((int)d.centerHorizontal[stage]);
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private DisplayLiquidList getListFromBuffer(LiquidStack stack, World world) {
        int liquidId = stack.itemID;
        if (liquidId == 0) {
            return null;
        }
        return this.getDisplayLiquidLists(liquidId, stack.itemMeta, world);
    }

    private void renderSolids(Pipe pipe, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        float light = pipe.worldObj.func_72801_o(pipe.xCoord, pipe.yCoord, pipe.zCoord);
        int count = 0;
        for (EntityData data : ((PipeTransportItems)pipe.transport).travelingEntities.values()) {
            if (count >= 10) break;
            this.doRenderItem(data.item, x + data.item.getPosition().x - (double)pipe.xCoord, y + data.item.getPosition().y - (double)pipe.yCoord, z + data.item.getPosition().z - (double)pipe.zCoord, light);
            ++count;
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public void doRenderItem(IPipedItem entityitem, double d, double d1, double d2, float f1) {
        if (entityitem == null || entityitem.getItemStack() == null) {
            return;
        }
        float renderScale = 0.7f;
        ItemStack itemstack = entityitem.getItemStack();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        this.dummyEntityItem.func_92058_a(itemstack);
        this.customRenderItem.func_77014_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopMatrix();
    }

    private class DisplayLiquidList {
        public int[] sideHorizontal = new int[40];
        public int[] sideVertical = new int[40];
        public int[] centerHorizontal = new int[40];
        public int[] centerVertical = new int[40];

        private DisplayLiquidList() {
        }
    }
}

