/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.RedstonePowerFramework;
import buildcraft.core.network.TileNetworkData;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidsWood
extends Pipe
implements IPowerReceptor {
    @TileNetworkData
    public int liquidToExtract;
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    protected int standardIconIndex = 21;
    protected int solidIconIndex = 10;
    long lastMining = 0L;
    boolean lastPower = false;

    public PipeLiquidsWood(int itemID) {
        this(new PipeLogicWood(), itemID);
    }

    protected PipeLiquidsWood(PipeLogic logic, int itemID) {
        super(new PipeTransportLiquids(), logic, itemID);
        this.powerProvider.configure(50, 1, 100, 1, 250);
        this.powerProvider.configurePowerPerdition(1, 1);
    }

    @Override
    public void doWork() {
        if (this.powerProvider.getEnergyStored() <= 0.0f) {
            return;
        }
        World w = this.worldObj;
        int meta = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        if (meta > 5) {
            return;
        }
        Position pos = new Position(this.xCoord, this.yCoord, this.zCoord, ForgeDirection.getOrientation((int)meta));
        pos.moveForwards(1.0);
        TileEntity tile = w.func_72796_p((int)pos.x, (int)pos.y, (int)pos.z);
        if (tile instanceof ITankContainer) {
            if (!PipeManager.canExtractLiquids(this, w, (int)pos.x, (int)pos.y, (int)pos.z)) {
                return;
            }
            if (this.liquidToExtract <= 1000) {
                this.liquidToExtract = (int)((float)this.liquidToExtract + this.powerProvider.useEnergy(1.0f, 1.0f, true) * 1000.0f);
            }
        }
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        int meta = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        if (this.liquidToExtract > 0 && meta < 6) {
            Position pos = new Position(this.xCoord, this.yCoord, this.zCoord, ForgeDirection.getOrientation((int)meta));
            pos.moveForwards(1.0);
            TileEntity tile = this.worldObj.func_72796_p((int)pos.x, (int)pos.y, (int)pos.z);
            if (tile instanceof ITankContainer) {
                ITankContainer container = (ITankContainer)tile;
                int flowRate = ((PipeTransportLiquids)this.transport).flowRate;
                LiquidStack extracted = container.drain(pos.orientation.getOpposite(), this.liquidToExtract > flowRate ? flowRate : this.liquidToExtract, false);
                int inserted = 0;
                if (extracted != null) {
                    inserted = ((PipeTransportLiquids)this.transport).fill(pos.orientation, extracted, true);
                    container.drain(pos.orientation.getOpposite(), inserted, true);
                }
                this.liquidToExtract -= inserted;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        int metadata = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        if (metadata == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        return this.getPowerProvider().getMaxEnergyReceived();
    }

    @Override
    public boolean canConnectRedstone() {
        if (PowerFramework.currentFramework instanceof RedstonePowerFramework) {
            return true;
        }
        return super.canConnectRedstone();
    }
}

