/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.network.IClientState;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogicDiamond;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsDiamond
extends Pipe
implements IPipeTransportItemsHook,
IClientState {
    public PipeItemsDiamond(int itemID) {
        super(new PipeTransportItems(), new PipeLogicDiamond(), itemID);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        switch (direction) {
            case UNKNOWN: {
                return 2;
            }
            case DOWN: {
                return 3;
            }
            case UP: {
                return 4;
            }
            case NORTH: {
                return 5;
            }
            case SOUTH: {
                return 6;
            }
            case WEST: {
                return 7;
            }
            case EAST: {
                return 8;
            }
        }
        throw new IllegalArgumentException("direction out of bounds");
    }

    @Override
    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        LinkedList<ForgeDirection> filteredOrientations = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> defaultOrientations = new LinkedList<ForgeDirection>();
        for (ForgeDirection dir : possibleOrientations) {
            boolean foundFilter = false;
            PipeLogicDiamond diamondLogic = (PipeLogicDiamond)this.logic;
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack stack = diamondLogic.func_70301_a(dir.ordinal() * 9 + slot);
                if (stack != null) {
                    foundFilter = true;
                }
                if (stack == null || stack.field_77993_c != item.getItemStack().field_77993_c) continue;
                if (Item.field_77698_e[item.getItemStack().field_77993_c].func_77645_m()) {
                    filteredOrientations.add(dir);
                    continue;
                }
                if (stack.func_77960_j() != item.getItemStack().func_77960_j()) continue;
                filteredOrientations.add(dir);
            }
            if (foundFilter) continue;
            defaultOrientations.add(dir);
        }
        if (filteredOrientations.size() != 0) {
            return filteredOrientations;
        }
        return defaultOrientations;
    }

    @Override
    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
    }

    @Override
    public void readjustSpeed(IPipedItem item) {
        ((PipeTransportItems)this.transport).defaultReajustSpeed(item);
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        NBTTagCompound nbt = new NBTTagCompound();
        ((PipeLogicDiamond)this.logic).writeToNBT(nbt);
        NBTBase.func_74731_a((NBTBase)nbt, (DataOutput)data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        NBTBase nbt = NBTBase.func_74739_b((DataInput)data);
        if (nbt instanceof NBTTagCompound) {
            this.logic.readFromNBT((NBTTagCompound)nbt);
        }
    }
}

