/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.network.BuildCraftPacket;
import buildcraft.transport.EntityData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;

public class PacketPipeTransportContent
extends BuildCraftPacket {
    private EntityData entityData;
    private int entityId;
    private ForgeDirection input;
    private ForgeDirection output;
    private int itemId;
    private byte stackSize;
    private int itemDamage;
    private float itemX;
    private float itemY;
    private float itemZ;
    private float speed;
    private boolean hasNBT;
    public int posX;
    public int posY;
    public int posZ;

    public PacketPipeTransportContent() {
    }

    public PacketPipeTransportContent(EntityData data) {
        this.entityData = data;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeFloat((float)this.entityData.item.getPosition().x);
        data.writeFloat((float)this.entityData.item.getPosition().y);
        data.writeFloat((float)this.entityData.item.getPosition().z);
        data.writeShort(this.entityData.item.getEntityId());
        data.writeByte((byte)this.entityData.input.ordinal());
        data.writeByte((byte)this.entityData.output.ordinal());
        data.writeShort(this.entityData.item.getItemStack().field_77993_c);
        data.writeByte((byte)this.entityData.item.getItemStack().field_77994_a);
        data.writeShort(this.entityData.item.getItemStack().func_77960_j());
        data.writeFloat(this.entityData.item.getSpeed());
        data.writeBoolean(this.entityData.item.getItemStack().func_77942_o());
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.itemX = data.readFloat();
        this.itemY = data.readFloat();
        this.itemZ = data.readFloat();
        this.posX = MathHelper.func_76141_d((float)this.itemX);
        this.posY = MathHelper.func_76141_d((float)this.itemY);
        this.posZ = MathHelper.func_76141_d((float)this.itemZ);
        this.entityId = data.readShort();
        this.input = ForgeDirection.getOrientation((int)data.readByte());
        this.output = ForgeDirection.getOrientation((int)data.readByte());
        this.itemId = data.readShort();
        this.stackSize = data.readByte();
        this.itemDamage = data.readShort();
        this.speed = data.readFloat();
        this.hasNBT = data.readBoolean();
    }

    public int getEntityId() {
        return this.entityId;
    }

    public ForgeDirection getInputOrientation() {
        return this.input;
    }

    public ForgeDirection getOutputOrientation() {
        return this.output;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public int getItemDamage() {
        return this.itemDamage;
    }

    public double getPosX() {
        return this.itemX;
    }

    public double getPosY() {
        return this.itemY;
    }

    public double getPosZ() {
        return this.itemZ;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean hasNBT() {
        return this.hasNBT;
    }

    @Override
    public int getID() {
        return 2;
    }
}

