/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.transport.IPipeEntry;
import buildcraft.core.DefaultProps;
import buildcraft.core.IMachine;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportLiquidsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.network.PacketLiquidUpdate;
import java.util.BitSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidEvent;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class PipeTransportLiquids
extends PipeTransport
implements ITankContainer {
    public static int LIQUID_IN_PIPE = 250;
    public static short INPUT_TTL = (short)60;
    public static short OUTPUT_TTL = (short)80;
    public static short OUTPUT_COOLDOWN = (short)30;
    private static final ForgeDirection[] directions = ForgeDirection.VALID_DIRECTIONS;
    private static final ForgeDirection[] orientations = ForgeDirection.values();
    public byte initClient = 0;
    public short travelDelay = (short)12;
    public short flowRate = (short)10;
    public LiquidStack[] renderCache = new LiquidStack[orientations.length];
    private final PipeSection[] internalTanks = new PipeSection[orientations.length];
    private final TransferState[] transferState = new TransferState[directions.length];
    private final int[] inputPerTick = new int[directions.length];
    private final short[] inputTTL = new short[]{0, 0, 0, 0, 0, 0};
    private final short[] outputTTL = new short[]{OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL};
    private final short[] outputCooldown = new short[]{0, 0, 0, 0, 0, 0};
    private final SafeTimeTracker tracker = new SafeTimeTracker();
    private int clientSyncCounter = 0;

    public PipeTransportLiquids() {
        for (ForgeDirection direction : orientations) {
            this.internalTanks[direction.ordinal()] = new PipeSection(this.getCapacity());
            if (direction == ForgeDirection.UNKNOWN) continue;
            this.transferState[direction.ordinal()] = TransferState.None;
        }
    }

    public int getCapacity() {
        return LIQUID_IN_PIPE;
    }

    public boolean canReceiveLiquid(ForgeDirection o) {
        Pipe pipe;
        TileEntity entity = this.container.getTile(o);
        if (!Utils.checkPipesConnections(this.container, entity)) {
            return false;
        }
        if (entity instanceof TileGenericPipe && ((pipe = ((TileGenericPipe)entity).pipe) == null || !pipe.inputOpen(o.getOpposite()))) {
            return false;
        }
        return entity instanceof IPipeEntry || entity instanceof ITankContainer;
    }

    @Override
    public void updateEntity() {
        if (CoreProxy.proxy.isRenderWorld(this.worldObj)) {
            return;
        }
        this.moveLiquids();
        if (this.tracker.markTimeIfDelay(this.worldObj, BuildCraftCore.updateFactor)) {
            PacketLiquidUpdate packet;
            boolean init = false;
            if ((long)(++this.clientSyncCounter) > BuildCraftCore.longUpdateFactor) {
                this.clientSyncCounter = 0;
                init = true;
            }
            if ((packet = this.computeLiquidUpdate(init, true)) != null) {
                CoreProxy.proxy.sendToPlayers(packet.getPacket(), this.worldObj, this.xCoord, this.yCoord, this.zCoord, DefaultProps.PIPE_CONTENTS_RENDER_DIST);
            }
        }
    }

    private PacketLiquidUpdate computeLiquidUpdate(boolean initPacket, boolean persistChange) {
        boolean changed = false;
        BitSet delta = new BitSet(21);
        if (this.initClient > 0) {
            this.initClient = (byte)(this.initClient - 1);
            if (this.initClient == 1) {
                changed = true;
                delta.set(0, 21);
            }
        }
        LiquidStack[] renderCache = (LiquidStack[])this.renderCache.clone();
        for (ForgeDirection dir : orientations) {
            int displayQty;
            LiquidStack current = this.internalTanks[dir.ordinal()].getLiquid();
            LiquidStack prev = renderCache[dir.ordinal()];
            if (prev == null && current == null) continue;
            if (prev == null && current != null) {
                changed = true;
                renderCache[dir.ordinal()] = current.copy();
                delta.set(dir.ordinal() * 3 + 0);
                delta.set(dir.ordinal() * 3 + 1);
                delta.set(dir.ordinal() * 3 + 2);
                continue;
            }
            if (prev != null && current == null) {
                changed = true;
                renderCache[dir.ordinal()] = null;
                delta.set(dir.ordinal() * 3 + 0);
                delta.set(dir.ordinal() * 3 + 1);
                delta.set(dir.ordinal() * 3 + 2);
                continue;
            }
            if (!prev.equals((Object)current) || initPacket) {
                changed = true;
                renderCache[dir.ordinal()] = current;
                delta.set(dir.ordinal() * 3 + 0);
                delta.set(dir.ordinal() * 3 + 1);
            }
            if ((displayQty = (prev.amount * 4 + current.amount) / 5) == 0 && current.amount > 0 || initPacket) {
                displayQty = current.amount;
            }
            if (prev.amount == (displayQty = Math.min(this.getCapacity(), displayQty)) && !initPacket) continue;
            changed = true;
            renderCache[dir.ordinal()].amount = displayQty;
            delta.set(dir.ordinal() * 3 + 2);
        }
        if (persistChange) {
            this.renderCache = renderCache;
        }
        if (changed || initPacket) {
            PacketLiquidUpdate packet = new PacketLiquidUpdate(this.xCoord, this.yCoord, this.zCoord, initPacket);
            packet.renderCache = renderCache;
            packet.delta = delta;
            return packet;
        }
        return null;
    }

    @Override
    public void sendDescriptionPacket() {
        super.sendDescriptionPacket();
        this.initClient = (byte)6;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (ForgeDirection direction : orientations) {
            if (nbttagcompound.func_74764_b("tank[" + direction.ordinal() + "]")) {
                this.internalTanks[direction.ordinal()].readFromNBT(nbttagcompound.func_74775_l("tank[" + direction.ordinal() + "]"));
            }
            if (direction == ForgeDirection.UNKNOWN) continue;
            this.transferState[direction.ordinal()] = TransferState.values()[nbttagcompound.func_74765_d("transferState[" + direction.ordinal() + "]")];
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (ForgeDirection direction : orientations) {
            NBTTagCompound subTag = new NBTTagCompound();
            this.internalTanks[direction.ordinal()].writeToNBT(subTag);
            nbttagcompound.func_74782_a("tank[" + direction.ordinal() + "]", (NBTBase)subTag);
            if (direction == ForgeDirection.UNKNOWN) continue;
            nbttagcompound.func_74777_a("transferState[" + direction.ordinal() + "]", (short)this.transferState[direction.ordinal()].ordinal());
        }
    }

    private void moveLiquids() {
        short newTimeSlot = (short)(this.worldObj.func_72820_D() % (long)this.travelDelay);
        short outputCount = this.computeCurrentConnectionStatesAndTickFlows(newTimeSlot);
        this.moveFromPipe(outputCount);
        this.moveFromCenter(outputCount);
        this.moveToCenter();
    }

    private void moveFromPipe(short outputCount) {
        if (outputCount > 0) {
            for (ForgeDirection o : directions) {
                LiquidStack liquidToPush;
                TileEntity target;
                if (this.transferState[o.ordinal()] != TransferState.Output || !((target = this.container.getTile(o)) instanceof ITankContainer) || (liquidToPush = this.internalTanks[o.ordinal()].drain(this.flowRate, false)) == null || liquidToPush.amount <= 0) continue;
                int filled = ((ITankContainer)target).fill(o.getOpposite(), liquidToPush, true);
                this.internalTanks[o.ordinal()].drain(filled, true);
                if (filled <= 0) {
                    int n = o.ordinal();
                    this.outputTTL[n] = (short)(this.outputTTL[n] - 1);
                    continue;
                }
                LiquidEvent.fireEvent((LiquidEvent)new LiquidEvent.LiquidMotionEvent(liquidToPush, this.worldObj, this.xCoord, this.yCoord, this.zCoord));
            }
        }
    }

    private void moveFromCenter(short outputCount) {
        LiquidStack pushStack = this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].getLiquid();
        int totalAvailable = this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].getAvailable();
        if (totalAvailable < 1) {
            return;
        }
        if (pushStack != null) {
            LiquidStack testStack = pushStack.copy();
            testStack.amount = this.flowRate;
            for (ForgeDirection direction : directions) {
                LiquidStack liquidToPush;
                if (this.transferState[direction.ordinal()] != TransferState.Output) continue;
                int available = this.internalTanks[direction.ordinal()].fill(testStack, false);
                int ammountToPush = (int)((double)available / (double)this.flowRate / (double)outputCount * (double)Math.min(this.flowRate, totalAvailable));
                if (ammountToPush < 1) {
                    ++ammountToPush;
                }
                if ((liquidToPush = this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].drain(ammountToPush, false)) == null) continue;
                int filled = this.internalTanks[direction.ordinal()].fill(liquidToPush, true);
                this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].drain(filled, true);
                if (filled <= 0) continue;
                LiquidEvent.fireEvent((LiquidEvent)new LiquidEvent.LiquidMotionEvent(liquidToPush, this.worldObj, this.xCoord, this.yCoord, this.zCoord));
            }
        }
    }

    private void moveToCenter() {
        int transferInCount = 0;
        LiquidStack stackInCenter = this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].drain(this.flowRate, false);
        int spaceAvailable = this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].getCapacity();
        if (stackInCenter != null) {
            spaceAvailable -= stackInCenter.amount;
        }
        for (ForgeDirection dir : directions) {
            LiquidStack testStack;
            this.inputPerTick[dir.ordinal()] = 0;
            if (this.transferState[dir.ordinal()] == TransferState.Output || (testStack = this.internalTanks[dir.ordinal()].drain(this.flowRate, false)) == null || stackInCenter != null && !stackInCenter.isLiquidEqual(testStack)) continue;
            this.inputPerTick[dir.ordinal()] = testStack.amount;
            ++transferInCount;
        }
        for (ForgeDirection dir : directions) {
            LiquidStack liquidToPush;
            if (this.transferState[dir.ordinal()] == TransferState.Output || this.inputPerTick[dir.ordinal()] <= 0) continue;
            int ammountToDrain = (int)((double)this.inputPerTick[dir.ordinal()] / (double)this.flowRate / (double)transferInCount * (double)Math.min(this.flowRate, spaceAvailable));
            if (ammountToDrain < 1) {
                ++ammountToDrain;
            }
            if ((liquidToPush = this.internalTanks[dir.ordinal()].drain(ammountToDrain, false)) == null) continue;
            int filled = this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].fill(liquidToPush, true);
            this.internalTanks[dir.ordinal()].drain(filled, true);
            if (filled <= 0) continue;
            LiquidEvent.fireEvent((LiquidEvent)new LiquidEvent.LiquidMotionEvent(liquidToPush, this.worldObj, this.xCoord, this.yCoord, this.zCoord));
        }
    }

    private short computeCurrentConnectionStatesAndTickFlows(short newTimeSlot) {
        short outputCount = 0;
        for (ForgeDirection direction : orientations) {
            this.internalTanks[direction.ordinal()].setTime(newTimeSlot);
            this.internalTanks[direction.ordinal()].moveLiquids();
            if (direction == ForgeDirection.UNKNOWN) continue;
            if (this.transferState[direction.ordinal()] == TransferState.Input) {
                int n = direction.ordinal();
                this.inputTTL[n] = (short)(this.inputTTL[n] - 1);
                if (this.inputTTL[direction.ordinal()] > 0) continue;
                this.transferState[direction.ordinal()] = TransferState.None;
                continue;
            }
            if (!this.container.pipe.outputOpen(direction)) {
                this.transferState[direction.ordinal()] = TransferState.None;
                continue;
            }
            if (this.outputCooldown[direction.ordinal()] > 0) {
                int n = direction.ordinal();
                this.outputCooldown[n] = (short)(this.outputCooldown[n] - 1);
                continue;
            }
            if (this.outputTTL[direction.ordinal()] <= 0) {
                this.transferState[direction.ordinal()] = TransferState.None;
                this.outputCooldown[direction.ordinal()] = OUTPUT_COOLDOWN;
                this.outputTTL[direction.ordinal()] = OUTPUT_TTL;
                continue;
            }
            if (!this.canReceiveLiquid(direction)) continue;
            this.transferState[direction.ordinal()] = TransferState.Output;
            outputCount = (short)(outputCount + 1);
        }
        return outputCount;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        for (ForgeDirection direction : directions) {
            if (Utils.checkPipesConnections(this.container.getTile(orientations[direction.ordinal()]), this.container)) continue;
            this.internalTanks[direction.ordinal()].reset();
            this.transferState[direction.ordinal()] = TransferState.None;
            this.renderCache[direction.ordinal()] = null;
        }
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        ITankContainer liq;
        Pipe pipe2;
        if (tile instanceof TileGenericPipe && BlockGenericPipe.isValid(pipe2 = ((TileGenericPipe)tile).pipe) && !(pipe2.transport instanceof PipeTransportLiquids)) {
            return false;
        }
        if (tile instanceof ITankContainer && (liq = (ITankContainer)tile).getTanks(side.getOpposite()) != null && liq.getTanks(side.getOpposite()).length > 0) {
            return true;
        }
        return tile instanceof TileGenericPipe || tile instanceof IMachine && ((IMachine)tile).manageLiquids();
    }

    public boolean isTriggerActive(ITrigger trigger) {
        return false;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(from.ordinal(), resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        int filled = this.container.pipe instanceof IPipeTransportLiquidsHook ? ((IPipeTransportLiquidsHook)((Object)this.container.pipe)).fill(orientations[tankIndex], resource, doFill) : this.internalTanks[tankIndex].fill(resource, doFill);
        if (filled > 0 && doFill && tankIndex != ForgeDirection.UNKNOWN.ordinal()) {
            this.transferState[tankIndex] = TransferState.Input;
            this.inputTTL[tankIndex] = INPUT_TTL;
        }
        return filled;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return this.internalTanks;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return null;
    }

    public static enum TransferState {
        None,
        Input,
        Output;

    }

    public class PipeSection
    extends LiquidTank {
        private short currentTime;
        private short[] incomming;

        public PipeSection(int capacity) {
            super(null, capacity);
            this.currentTime = 0;
            this.incomming = new short[PipeTransportLiquids.this.travelDelay];
        }

        public int fill(LiquidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            int maxToFill = Math.min(resource.amount, PipeTransportLiquids.this.flowRate - this.incomming[this.currentTime]);
            if (maxToFill <= 0) {
                return 0;
            }
            LiquidStack stackToFill = resource.copy();
            stackToFill.amount = maxToFill;
            int filled = super.fill(stackToFill, doFill);
            if (doFill) {
                short s = this.currentTime;
                this.incomming[s] = (short)(this.incomming[s] + filled);
            }
            return filled;
        }

        public LiquidStack drain(int maxDrain, boolean doDrain) {
            int maxToDrain = Math.min(maxDrain, Math.min(PipeTransportLiquids.this.flowRate, this.getAvailable()));
            if (maxToDrain < 0) {
                return null;
            }
            LiquidStack drained = super.drain(maxToDrain, doDrain);
            if (drained == null) {
                return null;
            }
            return drained;
        }

        public void moveLiquids() {
            this.incomming[this.currentTime] = 0;
        }

        public void setTime(short newTime) {
            this.currentTime = newTime;
        }

        public void reset() {
            this.setLiquid(null);
            this.incomming = new short[PipeTransportLiquids.this.travelDelay];
        }

        public int getAvailable() {
            int all = this.getLiquid() != null ? this.getLiquid().amount : 0;
            for (short slot : this.incomming) {
                all -= slot;
            }
            return all;
        }

        public LiquidTank readFromNBT(NBTTagCompound compoundTag) {
            this.setCapacity(compoundTag.func_74762_e("capacity"));
            for (int i = 0; i < PipeTransportLiquids.this.travelDelay; ++i) {
                this.incomming[i] = compoundTag.func_74765_d("in[" + i + "]");
            }
            this.setLiquid(LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)compoundTag));
            return this;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound subTag) {
            subTag.func_74768_a("capacity", this.getCapacity());
            for (int i = 0; i < PipeTransportLiquids.this.travelDelay; ++i) {
                this.incomming[i] = subTag.func_74765_d("in[" + i + "]");
            }
            if (this.getLiquid() != null) {
                this.getLiquid().writeToNBT(subTag);
            }
            return subTag;
        }
    }
}

