/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.core.IMachine;
import buildcraft.core.network.PacketSlotChange;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.CraftingHelper;
import buildcraft.core.utils.SimpleInventory;
import buildcraft.core.utils.Utils;
import buildcraft.silicon.ILaserTarget;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.ForgeDirection;

public class TileAssemblyAdvancedWorkbench
extends TileEntity
implements IInventory,
ILaserTarget,
IMachine {
    public InventoryCraftResult craftResult;
    private InternalInventoryCrafting internalInventoryCrafting;
    private SimpleInventory craftingSlots;
    private ItemStack[] storageSlots;
    private SlotCrafting craftSlot;
    private float storedEnergy;
    private float[] recentEnergy = new float[20];
    private boolean craftable;
    private int tick;
    private int recentEnergyAverage;
    private InternalPlayer internalPlayer;
    private IRecipe currentRecipe;

    public TileAssemblyAdvancedWorkbench() {
        this.craftingSlots = new SimpleInventory(9, "CraftingSlots", 1);
        this.storageSlots = new ItemStack[27];
        this.craftResult = new InventoryCraftResult();
    }

    public int func_70302_i_() {
        return 27;
    }

    public ItemStack func_70301_a(int var1) {
        if (var1 < this.storageSlots.length) {
            return this.storageSlots[var1];
        }
        return null;
    }

    public ItemStack func_70298_a(int var1, int var2) {
        if (var1 < this.storageSlots.length && this.storageSlots[var1] != null) {
            if (this.storageSlots[var1].field_77994_a <= var2) {
                ItemStack var3 = this.storageSlots[var1];
                this.storageSlots[var1] = null;
                this.func_70296_d();
                return var3;
            }
            ItemStack var3 = this.storageSlots[var1].func_77979_a(var2);
            if (this.storageSlots[var1].field_77994_a == 0) {
                this.storageSlots[var1] = null;
            }
            this.func_70296_d();
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        if (var1 >= this.storageSlots.length) {
            return null;
        }
        if (this.storageSlots[var1] != null) {
            ItemStack var2 = this.storageSlots[var1];
            this.storageSlots[var1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        if (var1 >= this.storageSlots.length) {
            return;
        }
        this.storageSlots[var1] = var2;
        if (var2 != null && var2.field_77994_a > this.func_70297_j_()) {
            var2.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.storageSlots.length; ++var3) {
            if (this.storageSlots[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.storageSlots[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1nbtTagCompound.func_74782_a("StorageSlots", (NBTBase)var2);
        this.craftingSlots.writeToNBT(par1nbtTagCompound);
        par1nbtTagCompound.func_74776_a("StoredEnergy", this.storedEnergy);
    }

    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        NBTTagList var2 = par1nbtTagCompound.func_74761_m("StorageSlots");
        this.storageSlots = new ItemStack[27];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < 0 || var5 >= this.storageSlots.length) continue;
            this.storageSlots[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.craftingSlots.readFromNBT(par1nbtTagCompound);
        this.storedEnergy = par1nbtTagCompound.func_74760_g("StoredEnergy");
    }

    public String func_70303_b() {
        return "AdvancedWorkbench";
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.craftable = this.craftResult.func_70301_a(0) != null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int getRecentEnergyAverage() {
        return this.recentEnergyAverage;
    }

    public float getStoredEnergy() {
        return this.storedEnergy;
    }

    public float getRequiredEnergy() {
        return this.craftResult.func_70301_a(0) != null ? 500.0f : 0.0f;
    }

    public void func_70316_g() {
        if (this.internalPlayer == null) {
            this.internalInventoryCrafting = new InternalInventoryCrafting();
            this.internalPlayer = new InternalPlayer();
            this.craftSlot = new SlotCrafting((EntityPlayer)this.internalPlayer, (IInventory)this.internalInventoryCrafting, (IInventory)this.craftResult, 0, 0, 0);
            this.updateCraftingResults();
        }
        if (!CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            return;
        }
        this.updateCraftingResults();
        ++this.tick;
        this.tick %= this.recentEnergy.length;
        this.recentEnergy[this.tick] = 0.0f;
        while (this.storedEnergy >= this.getRequiredEnergy() && this.craftResult.func_70301_a(0) != null) {
            ItemStack[] tempStorage = Arrays.copyOf(this.storageSlots, this.storageSlots.length);
            this.internalInventoryCrafting.tempStacks = tempStorage;
            this.internalInventoryCrafting.hitCount = new int[27];
            for (int j = 0; j < this.craftingSlots.func_70302_i_(); ++j) {
                if (this.craftingSlots.func_70301_a(j) == null) {
                    this.internalInventoryCrafting.bindings[j] = -1;
                    continue;
                }
                boolean matchedStorage = false;
                for (int i = 0; i < tempStorage.length; ++i) {
                    if (tempStorage[i] == null || !this.craftingSlots.func_70301_a(j).func_77969_a(tempStorage[i]) || this.internalInventoryCrafting.hitCount[i] >= tempStorage[i].field_77994_a || this.internalInventoryCrafting.hitCount[i] >= tempStorage[i].func_77976_d()) continue;
                    this.internalInventoryCrafting.bindings[j] = i;
                    int n = i;
                    this.internalInventoryCrafting.hitCount[n] = this.internalInventoryCrafting.hitCount[n] + 1;
                    matchedStorage = true;
                    break;
                }
                if (matchedStorage) continue;
                this.craftable = false;
                this.internalInventoryCrafting.tempStacks = null;
                this.internalInventoryCrafting.hitCount = null;
                return;
            }
            this.craftSlot.func_82870_a((EntityPlayer)this.internalPlayer, this.craftResult.func_70301_a(0));
            for (int i = 0; i < tempStorage.length; ++i) {
                if (tempStorage[i] == null || tempStorage[i].field_77994_a > 0) continue;
                tempStorage[i] = null;
            }
            this.storageSlots = tempStorage;
            this.storedEnergy -= this.getRequiredEnergy();
            ArrayList outputs = Lists.newArrayList((Object[])new ItemStack[]{this.craftResult.func_70301_a(0).func_77946_l()});
            for (int i = 0; i < this.internalPlayer.field_71071_by.field_70462_a.length; ++i) {
                if (this.internalPlayer.field_71071_by.field_70462_a[i] == null) continue;
                outputs.add(this.internalPlayer.field_71071_by.field_70462_a[i]);
                this.internalPlayer.field_71071_by.field_70462_a[i] = null;
            }
            for (ItemStack output : outputs) {
                boolean putToPipe = Utils.addToRandomPipeEntry(this, ForgeDirection.UP, output);
                if (putToPipe) continue;
                for (int i = 0; i < this.storageSlots.length && output.field_77994_a > 0; ++i) {
                    if (this.storageSlots[i] != null && output.func_77985_e() && output.func_77969_a(this.storageSlots[i])) {
                        this.storageSlots[i].field_77994_a += output.field_77994_a;
                        if (this.storageSlots[i].field_77994_a > output.func_77976_d()) {
                            output.field_77994_a = this.storageSlots[i].field_77994_a - output.func_77976_d();
                            this.storageSlots[i].field_77994_a = output.func_77976_d();
                            continue;
                        }
                        output.field_77994_a = 0;
                        continue;
                    }
                    if (this.storageSlots[i] != null) continue;
                    this.storageSlots[i] = output.func_77946_l();
                    output.field_77994_a = 0;
                }
                if (output.field_77994_a > 0) {
                    output = Utils.addToRandomInventory(output, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, ForgeDirection.UNKNOWN);
                }
                if (output.field_77994_a <= 0) continue;
                Utils.dropItems(this.field_70331_k, output, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    public void updateCraftingMatrix(int slot, ItemStack stack) {
        this.craftingSlots.func_70299_a(slot, stack);
        this.updateCraftingResults();
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            PacketSlotChange packet = new PacketSlotChange(70, this.field_70329_l, this.field_70330_m, this.field_70327_n, slot, stack);
            CoreProxy.proxy.sendToServer(packet.getPacket());
        }
    }

    private void updateCraftingResults() {
        if (this.internalInventoryCrafting == null) {
            return;
        }
        this.internalInventoryCrafting.recipeUpdate(true);
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a((InventoryCrafting)this.internalInventoryCrafting, this.field_70331_k)) {
            this.currentRecipe = CraftingHelper.findMatchingRecipe(this.internalInventoryCrafting, this.field_70331_k);
        }
        ItemStack resultStack = null;
        if (this.currentRecipe != null) {
            resultStack = this.currentRecipe.func_77572_b((InventoryCrafting)this.internalInventoryCrafting);
        }
        this.craftResult.func_70299_a(0, resultStack);
        this.internalInventoryCrafting.recipeUpdate(false);
        this.func_70296_d();
    }

    public IInventory getCraftingSlots() {
        return this.craftingSlots;
    }

    public ItemStack getOutputSlot() {
        return this.craftResult.func_70301_a(0);
    }

    @Override
    public boolean hasCurrentWork() {
        return this.craftable;
    }

    @Override
    public void receiveLaserEnergy(float energy) {
        this.storedEnergy += energy;
        int n = this.tick;
        this.recentEnergy[n] = this.recentEnergy[n] + energy;
    }

    @Override
    public int getXCoord() {
        return this.field_70329_l;
    }

    @Override
    public int getYCoord() {
        return this.field_70330_m;
    }

    @Override
    public int getZCoord() {
        return this.field_70327_n;
    }

    @Override
    public boolean isActive() {
        return this.hasCurrentWork();
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowActions() {
        return true;
    }

    public void getGUINetworkData(int i, int j) {
        int currentStored = (int)((double)this.storedEnergy * 100.0);
        switch (i) {
            case 1: {
                currentStored = currentStored & 0xFFFF0000 | j & 0xFFFF;
                this.storedEnergy = (float)currentStored / 100.0f;
                break;
            }
            case 3: {
                currentStored = currentStored & 0xFFFF | (j & 0xFFFF) << 16;
                this.storedEnergy = (float)currentStored / 100.0f;
                break;
            }
            case 4: {
                this.recentEnergyAverage = this.recentEnergyAverage & 0xFFFF0000 | j & 0xFFFF;
                break;
            }
            case 5: {
                this.recentEnergyAverage = this.recentEnergyAverage & 0xFFFF | (j & 0xFFFF) << 16;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int currentStored = (int)((double)this.storedEnergy * 100.0);
        int lRecentEnergy = 0;
        for (int i = 0; i < this.recentEnergy.length; ++i) {
            lRecentEnergy += (int)((double)this.recentEnergy[i] * 100.0 / (double)(this.recentEnergy.length - 1));
        }
        iCrafting.func_71112_a(container, 1, currentStored & 0xFFFF);
        iCrafting.func_71112_a(container, 3, currentStored >>> 16 & 0xFFFF);
        iCrafting.func_71112_a(container, 4, lRecentEnergy & 0xFFFF);
        iCrafting.func_71112_a(container, 5, lRecentEnergy >>> 16 & 0xFFFF);
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    private final class InternalPlayer
    extends EntityPlayer {
        public InternalPlayer() {
            super(TileAssemblyAdvancedWorkbench.this.field_70331_k);
        }

        public void func_70006_a(String var1) {
        }

        public boolean func_70003_b(int var1, String var2) {
            return false;
        }

        public ChunkCoordinates func_82114_b() {
            return null;
        }
    }

    private final class InternalInventoryCrafting
    extends InventoryCrafting {
        int[] bindings;
        ItemStack[] tempStacks;
        public int[] hitCount;
        private boolean useRecipeStack;

        private InternalInventoryCrafting() {
            super((Container)new InternalInventoryCraftingContainer(), 3, 3);
            this.bindings = new int[9];
        }

        public ItemStack func_70301_a(int par1) {
            if (par1 >= 0 && par1 < 9) {
                if (this.useRecipeStack || this.tempStacks == null) {
                    return TileAssemblyAdvancedWorkbench.this.craftingSlots.func_70301_a(par1);
                }
                if (this.bindings[par1] >= 0) {
                    return this.tempStacks[this.bindings[par1]];
                }
            }
            return null;
        }

        public void func_70299_a(int par1, ItemStack par2ItemStack) {
            if (this.tempStacks != null) {
                this.tempStacks[this.bindings[par1]] = par2ItemStack;
            }
        }

        public ItemStack func_70298_a(int par1, int par2) {
            if (this.tempStacks != null) {
                return this.tempStacks[this.bindings[par1]].func_77979_a(par2);
            }
            return null;
        }

        public void recipeUpdate(boolean flag) {
            this.useRecipeStack = flag;
        }
    }

    private final class InternalInventoryCraftingContainer
    extends Container {
        private InternalInventoryCraftingContainer() {
        }

        public boolean func_75145_c(EntityPlayer var1) {
            return false;
        }
    }
}

