/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.core.IMachine;
import buildcraft.core.utils.BlockUtil;
import buildcraft.core.utils.Utils;
import buildcraft.factory.TileMachine;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileMiningWell
extends TileMachine
implements IMachine,
IPowerReceptor,
IPipeConnection {
    boolean isDigging = true;
    IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    public TileMiningWell() {
        this.powerProvider.configure(50, 1, 25, 25, 1000);
    }

    @Override
    public void doWork() {
        if (this.powerProvider.useEnergy(25.0f, 25.0f, true) < 25.0f) {
            return;
        }
        World world = this.field_70331_k;
        int depth = this.field_70330_m - 1;
        while (world.func_72798_a(this.field_70329_l, depth, this.field_70327_n) == BuildCraftFactory.plainPipeBlock.field_71990_ca) {
            --depth;
        }
        if (depth < 0 || !BlockUtil.canChangeBlock(world, this.field_70329_l, depth, this.field_70327_n)) {
            this.isDigging = false;
            return;
        }
        int blockId = world.func_72798_a(this.field_70329_l, depth, this.field_70327_n);
        List stacks = BlockUtil.getItemStackFromBlock(this.field_70331_k, this.field_70329_l, depth, this.field_70327_n);
        world.func_94575_c(this.field_70329_l, depth, this.field_70327_n, BuildCraftFactory.plainPipeBlock.field_71990_ca);
        if (blockId == 0) {
            return;
        }
        if (stacks == null || stacks.isEmpty()) {
            return;
        }
        for (ItemStack stack : stacks) {
            ItemStack added = Utils.addToRandomInventory(stack, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, ForgeDirection.UNKNOWN);
            stack.field_77994_a -= added.field_77994_a;
            if (stack.field_77994_a <= 0 || Utils.addToRandomPipeEntry(this, ForgeDirection.UNKNOWN, stack) && stack.field_77994_a <= 0) continue;
            float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(world, (double)((float)this.field_70329_l + f), (double)((float)this.field_70330_m + f1 + 0.5f), (double)((float)this.field_70327_n + f2), stack);
            entityitem.lifespan = BuildCraftCore.itemLifespan;
            entityitem.field_70293_c = 10;
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 1.0f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
            world.func_72838_d((Entity)entityitem);
        }
    }

    @Override
    public boolean isActive() {
        return this.isDigging;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        return true;
    }

    @Override
    public boolean allowActions() {
        return false;
    }
}

