/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowing;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.liquids.ILiquid;

public class BlockOilFlowing
extends BlockFlowing
implements ILiquid {
    int field_72214_a = 0;
    boolean[] field_72212_b = new boolean[4];
    int[] field_72213_c = new int[4];

    public BlockOilFlowing(int i, Material material) {
        super(i, material);
        this.func_71848_c(100.0f);
        this.func_71868_h(3);
    }

    public int func_71857_b() {
        return BuildCraftCore.oilModel;
    }

    private void updateFlow(World par1World, int par2, int par3, int par4) {
        int l = par1World.func_72805_g(par2, par3, par4);
        par1World.func_72832_d(par2, par3, par4, this.field_71990_ca + 1, l, 2);
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        int flowDecay;
        int oldDecay = this.func_72198_f_(world, x, y, z);
        int increment = 1;
        if (oldDecay > 0) {
            int decayAbove;
            this.field_72214_a = 0;
            int minFlowDecay = this.func_72211_e(world, x - 1, y, z, -100);
            minFlowDecay = this.func_72211_e(world, x + 1, y, z, minFlowDecay);
            minFlowDecay = this.func_72211_e(world, x, y, z - 1, minFlowDecay);
            flowDecay = (minFlowDecay = this.func_72211_e(world, x, y, z + 1, minFlowDecay)) + increment;
            if (flowDecay >= 8 || minFlowDecay < 0) {
                flowDecay = -1;
            }
            if ((decayAbove = this.func_72198_f_(world, x, y + 1, z)) >= 0) {
                flowDecay = decayAbove >= 8 ? decayAbove : decayAbove + 8;
            }
            if (flowDecay == oldDecay) {
                this.updateFlow(world, x, y, z);
            } else {
                oldDecay = flowDecay;
                if (flowDecay < 0) {
                    world.func_94571_i(x, y, z);
                } else {
                    world.func_72921_c(x, y, z, flowDecay, 2);
                    world.func_72836_a(x, y, z, this.field_71990_ca, this.func_71859_p_(world));
                    world.func_72898_h(x, y, z, this.field_71990_ca);
                }
            }
        } else {
            this.updateFlow(world, x, y, z);
        }
        if (this.liquidCanDisplaceBlock(world, x, y - 1, z)) {
            if (oldDecay >= 8) {
                this.flowIntoBlock(world, x, y - 1, z, oldDecay);
            } else {
                this.flowIntoBlock(world, x, y - 1, z, oldDecay + 8);
            }
        } else if (oldDecay >= 0 && (oldDecay == 0 || this.blockBlocksFlow(world, x, y - 1, z))) {
            boolean[] flowDirection = this.getOptimalFlowDirections(world, x, y, z);
            flowDecay = oldDecay + increment;
            if (oldDecay >= 8) {
                flowDecay = 1;
            }
            if (flowDecay >= 8) {
                return;
            }
            if (flowDirection[0]) {
                this.flowIntoBlock(world, x - 1, y, z, flowDecay);
            }
            if (flowDirection[1]) {
                this.flowIntoBlock(world, x + 1, y, z, flowDecay);
            }
            if (flowDirection[2]) {
                this.flowIntoBlock(world, x, y, z - 1, flowDecay);
            }
            if (flowDirection[3]) {
                this.flowIntoBlock(world, x, y, z + 1, flowDecay);
            }
        }
    }

    private void flowIntoBlock(World world, int i, int j, int k, int l) {
        if (this.liquidCanDisplaceBlock(world, i, j, k)) {
            int blockId = world.func_72798_a(i, j, k);
            if (blockId > 0) {
                Block.field_71973_m[blockId].func_71897_c(world, i, j, k, world.func_72805_g(i, j, k), 0);
            }
            world.func_72832_d(i, j, k, this.field_71990_ca, l, 3);
        }
    }

    private int calculateFlowCost(World world, int i, int j, int k, int l, int i1) {
        int j1 = 1000;
        for (int k1 = 0; k1 < 4; ++k1) {
            int k2;
            if (k1 == 0 && i1 == 1 || k1 == 1 && i1 == 0 || k1 == 2 && i1 == 3 || k1 == 3 && i1 == 2) continue;
            int l1 = i;
            int i2 = j;
            int j2 = k;
            if (k1 == 0) {
                --l1;
            }
            if (k1 == 1) {
                ++l1;
            }
            if (k1 == 2) {
                --j2;
            }
            if (k1 == 3) {
                ++j2;
            }
            if (this.blockBlocksFlow(world, l1, i2, j2) || world.func_72803_f(l1, i2, j2) == this.field_72018_cp && world.func_72805_g(l1, i2, j2) == 0) continue;
            if (!this.blockBlocksFlow(world, l1, i2 - 1, j2)) {
                return l;
            }
            if (l >= 4 || (k2 = this.calculateFlowCost(world, l1, i2, j2, l + 1, k1)) >= j1) continue;
            j1 = k2;
        }
        return j1;
    }

    private boolean[] getOptimalFlowDirections(World world, int i, int j, int k) {
        for (int l = 0; l < 4; ++l) {
            this.field_72213_c[l] = 1000;
            int j1 = i;
            int i2 = j;
            int j2 = k;
            if (l == 0) {
                --j1;
            }
            if (l == 1) {
                ++j1;
            }
            if (l == 2) {
                --j2;
            }
            if (l == 3) {
                ++j2;
            }
            if (this.blockBlocksFlow(world, j1, i2, j2) || world.func_72803_f(j1, i2, j2) == this.field_72018_cp && world.func_72805_g(j1, i2, j2) == 0) continue;
            this.field_72213_c[l] = !this.blockBlocksFlow(world, j1, i2 - 1, j2) ? 0 : this.calculateFlowCost(world, j1, i2, j2, 1, l);
        }
        int i1 = this.field_72213_c[0];
        for (int k1 = 1; k1 < 4; ++k1) {
            if (this.field_72213_c[k1] >= i1) continue;
            i1 = this.field_72213_c[k1];
        }
        for (int l1 = 0; l1 < 4; ++l1) {
            this.field_72212_b[l1] = this.field_72213_c[l1] == i1;
        }
        return this.field_72212_b;
    }

    private boolean blockBlocksFlow(World par1World, int par2, int par3, int par4) {
        int l = par1World.func_72798_a(par2, par3, par4);
        if (l != Block.field_72054_aE.field_71990_ca && l != Block.field_72045_aL.field_71990_ca && l != Block.field_72053_aD.field_71990_ca && l != Block.field_72055_aF.field_71990_ca && l != Block.field_72040_aX.field_71990_ca) {
            if (l == 0) {
                return false;
            }
            Material material = Block.field_71973_m[l].field_72018_cp;
            return material == Material.field_76237_B ? true : material.func_76230_c();
        }
        return true;
    }

    protected int func_72211_e(World par1World, int par2, int par3, int par4, int par5) {
        int i1 = this.func_72198_f_(par1World, par2, par3, par4);
        if (i1 < 0) {
            return par5;
        }
        if (i1 == 0) {
            ++this.field_72214_a;
        }
        if (i1 >= 8) {
            i1 = 0;
        }
        return par5 >= 0 && i1 >= par5 ? par5 : i1;
    }

    private boolean liquidCanDisplaceBlock(World world, int i, int j, int k) {
        Material material = world.func_72803_f(i, j, k);
        if (material == this.field_72018_cp) {
            return false;
        }
        return !this.blockBlocksFlow(world, i, j, k);
    }

    public int stillLiquidId() {
        return BuildCraftEnergy.oilStill.field_71990_ca;
    }

    public boolean isMetaSensitive() {
        return false;
    }

    public int stillLiquidMeta() {
        return 0;
    }

    public boolean isBlockReplaceable(World world, int i, int j, int k) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.field_94425_a = new Icon[]{iconRegister.func_94245_a("buildcraft:oil"), iconRegister.func_94245_a("buildcraft:oil_flow")};
    }
}

